/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.ae2addonlib.registry;

import appeng.block.AEBaseBlock;
import appeng.block.AEBaseBlockItem;
import appeng.core.definitions.BlockDefinition;
import appeng.core.definitions.ItemDefinition;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.pedroksl.ae2addonlib.registry.ItemRegistry;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class BlockRegistry {
    private static final Logger LOG = LogUtils.getLogger();
    private static final Map<String, DeferredRegister.Blocks> DRMap = new HashMap<String, DeferredRegister.Blocks>();
    private static final Map<String, List<BlockDefinition<?>>> BLOCKS = new HashMap();
    private final String modId;

    public BlockRegistry(String modId) {
        if (DRMap.containsKey(modId) && FMLEnvironment.dist.isClient()) {
            LOG.error("Tried to initialize BlockRegistry on Client Dist with mod id {}", (Object)modId);
            throw new IllegalStateException();
        }
        this.modId = modId;
        DRMap.put(modId, DeferredRegister.createBlocks((String)modId));
        BLOCKS.put(modId, new ArrayList());
    }

    static DeferredRegister.Blocks getDR(String modId) {
        DeferredRegister.Blocks dr = DRMap.getOrDefault(modId, null);
        if (dr == null) {
            LOG.error("Tried to access uninitialized deferred register with mod id {}", (Object)modId);
            throw new IllegalStateException();
        }
        return dr;
    }

    public List<BlockDefinition<?>> getBlocks() {
        return BlockRegistry.getBlocks(this.modId);
    }

    public static List<BlockDefinition<?>> getBlocks(String modId) {
        return Collections.unmodifiableList(BLOCKS.getOrDefault(modId, new ArrayList()));
    }

    protected static <T extends Block> BlockDefinition<T> block(String modId, String englishName, String id, Supplier<T> blockSupplier) {
        return BlockRegistry.block(modId, englishName, id, blockSupplier, null);
    }

    protected static <T extends Block> BlockDefinition<T> block(String modId, String englishName, String id, Supplier<T> blockSupplier, @Nullable BiFunction<Block, Item.Properties, BlockItem> itemFactory) {
        DeferredBlock deferredBlock = BlockRegistry.getDR(modId).register(id, blockSupplier);
        DeferredItem deferredItem = ItemRegistry.getDR(modId).register(id, () -> {
            Block block = (Block)deferredBlock.get();
            Item.Properties itemProperties = new Item.Properties();
            if (itemFactory != null) {
                BlockItem item = (BlockItem)itemFactory.apply(block, new Item.Properties());
                if (item == null) {
                    ResourceLocation rl = ResourceLocation.fromNamespaceAndPath((String)BlockRegistry.getDR(modId).getNamespace(), (String)id);
                    throw new IllegalArgumentException("BlockItem factory for " + String.valueOf(rl) + " return null");
                }
                return item;
            }
            if (block instanceof AEBaseBlock) {
                return new AEBaseBlockItem(block, itemProperties);
            }
            return new BlockItem(block, itemProperties);
        });
        BlockDefinition definition = new BlockDefinition(englishName, deferredBlock, new ItemDefinition(englishName, deferredItem));
        BLOCKS.get(modId).add(definition);
        return definition;
    }

    public void register(IEventBus eventBus) {
        BlockRegistry.getDR(this.modId).register(eventBus);
    }
}

