/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.ae2addonlib.registry;

import com.mojang.logging.LogUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.slf4j.Logger;

public class ComponentRegistry {
    private static final Logger LOG = LogUtils.getLogger();
    private static final Map<String, DeferredRegister<DataComponentType<?>>> DRMap = new HashMap();
    private final String modId;

    public ComponentRegistry(String modId) {
        if (DRMap.containsKey(modId) && FMLEnvironment.dist.isClient()) {
            LOG.error("Tried to initialize ComponentRegistry on Client Dist with mod id {}", (Object)modId);
            throw new IllegalStateException();
        }
        this.modId = modId;
        DRMap.put(modId, DeferredRegister.create((ResourceKey)Registries.DATA_COMPONENT_TYPE, (String)modId));
    }

    static DeferredRegister<DataComponentType<?>> getDR(String modId) {
        DeferredRegister dr = DRMap.getOrDefault(modId, null);
        if (dr == null) {
            LOG.error("Tried to access uninitialized deferred register with mod id {}", (Object)modId);
            throw new IllegalStateException();
        }
        return dr;
    }

    public Collection<DeferredHolder<DataComponentType<?>, ? extends DataComponentType<?>>> getEntries() {
        return ComponentRegistry.getEntries(this.modId);
    }

    public static Collection<DeferredHolder<DataComponentType<?>, ? extends DataComponentType<?>>> getEntries(String modId) {
        try {
            return ComponentRegistry.getDR(modId).getEntries();
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }

    protected static <T> DataComponentType<T> register(String modId, String id, Consumer<DataComponentType.Builder<T>> customizer) {
        DataComponentType.Builder builder = DataComponentType.builder();
        customizer.accept(builder);
        DataComponentType componentType = builder.build();
        ComponentRegistry.getDR(modId).register(id, () -> componentType);
        return componentType;
    }

    public void register(IEventBus eventBus) {
        ComponentRegistry.getDR(this.modId).register(eventBus);
    }
}

