/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.ae2addonlib.util;

import java.awt.Color;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public final class Colors {
    public static final Colors LIGHT_GRAY_BLUE = Colors.ofArgb(-5394236);
    public static final Colors DARK_GRAY_BLUE = Colors.ofArgb(-12501164);
    public static final Colors LIGHT_PURPLE = Colors.ofArgb(2021479361);
    public static final Colors PURPLE = Colors.ofArgb(-9367387);
    public static final Colors WHITE = new Colors(255, 255, 255);
    public static final Colors LIGHT_GRAY = new Colors(192, 192, 192);
    public static final Colors GRAY = new Colors(128, 128, 128);
    public static final Colors DARK_GRAY = new Colors(64, 64, 64);
    public static final Colors BLACK = new Colors(0, 0, 0);
    public static final Colors RED = new Colors(255, 0, 0);
    public static final Colors PINK = new Colors(255, 175, 175);
    public static final Colors ORANGE = new Colors(255, 200, 0);
    public static final Colors YELLOW = new Colors(255, 255, 0);
    public static final Colors GREEN = new Colors(0, 255, 0);
    public static final Colors MAGENTA = new Colors(255, 0, 255);
    public static final Colors CYAN = new Colors(0, 255, 255);
    public static final Colors BLUE = new Colors(0, 0, 255);
    private final int red;
    private final int green;
    private final int blue;
    private final int alpha;

    Colors(int red, int green, int blue) {
        this(red, green, blue, 255);
    }

    Colors(int red, int green, int blue, int alpha) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = alpha;
    }

    public static Colors ofArgb(int color) {
        int alpha = color >> 24 & 0xFF;
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        return new Colors(red, green, blue, alpha);
    }

    public static Colors ofRgb(int color) {
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        return new Colors(red, green, blue);
    }

    public static Colors ofHsv(float hue, float saturation, float value) {
        return Colors.ofArgb(Mth.hsvToArgb((float)(hue - 5.0E-8f), (float)saturation, (float)value, (int)255));
    }

    @NotNull
    public static Colors ofHsv(float hue, float saturation, float value, float alpha) {
        return Colors.ofArgb(Mth.hsvToArgb((float)(hue - 5.0E-8f), (float)saturation, (float)value, (int)((int)alpha * 255)));
    }

    public float r() {
        return (float)this.red / 255.0f;
    }

    public float g() {
        return (float)this.green / 255.0f;
    }

    public float b() {
        return (float)this.blue / 255.0f;
    }

    public float a() {
        return (float)this.alpha / 255.0f;
    }

    public int argb() {
        return FastColor.ARGB32.color((int)this.alpha, (int)this.red, (int)this.green, (int)this.blue);
    }

    public int argb(int alpha) {
        return FastColor.ARGB32.color((int)alpha, (int)this.red, (int)this.green, (int)this.blue);
    }

    public int rgb() {
        return FastColor.ARGB32.color((int)this.red, (int)this.green, (int)this.blue);
    }

    public HSV hsv() {
        float[] vals = new float[3];
        Color.RGBtoHSB(this.red, this.green, this.blue, vals);
        return new HSV(vals[0], vals[1], vals[2]);
    }

    public record HSV(float hue, float saturation, float value) {
    }
}

