/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.ae2netanalyser.client.render;

import com.glodblock.github.ae2netanalyser.common.items.ItemTickAnalyzer;
import com.glodblock.github.ae2netanalyser.common.me.ticker.ProfileData;
import java.util.function.DoublePredicate;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class ProfileDataHandler {
    private static ProfileData DATA = null;
    private static ItemTickAnalyzer.TickConfig CONFIG = new ItemTickAnalyzer.TickConfig(60, true, true, true, true);
    private static boolean needUpdate = true;

    public static void receiveData(ProfileData data) {
        DATA = data != null && data.isCorrupt() ? null : data;
        needUpdate = true;
    }

    @Nullable
    public static ProfileData pullData() {
        return DATA;
    }

    public static boolean update() {
        boolean ret = needUpdate;
        needUpdate = false;
        return ret;
    }

    public static DoublePredicate renderFilter() {
        return rate -> {
            if (CONFIG.op1() && rate < 5.0) {
                return true;
            }
            if (CONFIG.op2() && 5.0 <= rate && rate < 100.0) {
                return true;
            }
            if (CONFIG.op3() && 100.0 <= rate && rate < 500.0) {
                return true;
            }
            return CONFIG.op4() && rate >= 500.0;
        };
    }

    public static void updateConfig(ItemTickAnalyzer.TickConfig config) {
        CONFIG = config;
        needUpdate = true;
    }
}

