/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.ae2netanalyser.common.me.tracker;

import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import net.minecraft.core.GlobalPos;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;

public final class PlayerTracker {
    private static final Reference2ObjectMap<Player, Tracker> TRACKERS = new Reference2ObjectOpenHashMap();

    public static void init() {
        NeoForge.EVENT_BUS.register(PlayerTracker.class);
    }

    public static boolean needUpdate(Player player, GlobalPos pos) {
        long time = player.level().getGameTime();
        if (TRACKERS.containsKey((Object)player)) {
            Tracker last = (Tracker)TRACKERS.get((Object)player);
            if (!last.pos.equals((Object)pos) || time - last.time > 100L) {
                TRACKERS.put((Object)player, (Object)new Tracker(pos, time));
                return true;
            }
            return false;
        }
        TRACKERS.put((Object)player, (Object)new Tracker(pos, time));
        return true;
    }

    @SubscribeEvent
    public static void clear(ServerStartingEvent event) {
        TRACKERS.clear();
    }

    @SubscribeEvent
    public static void playerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        PlayerTracker.remove(event.getEntity());
    }

    @SubscribeEvent
    public static void playChangeWorld(PlayerEvent.PlayerChangedDimensionEvent event) {
        PlayerTracker.remove(event.getEntity());
    }

    @SubscribeEvent
    public static void playRespawn(PlayerEvent.PlayerRespawnEvent event) {
        PlayerTracker.remove(event.getEntity());
    }

    private static void remove(Player player) {
        TRACKERS.remove((Object)player);
    }

    public record Tracker(GlobalPos pos, long time) {
    }
}

