/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.common.blocks;

import appeng.api.orientation.IOrientationStrategy;
import appeng.api.orientation.OrientationStrategies;
import appeng.block.AEBaseEntityBlock;
import appeng.menu.MenuOpener;
import appeng.menu.locator.MenuHostLocator;
import appeng.menu.locator.MenuLocators;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.SoundActions;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.pedroksl.advanced_ae.common.definitions.AAEMenus;
import net.pedroksl.advanced_ae.common.entities.ReactionChamberEntity;

public class ReactionChamberBlock
extends AEBaseEntityBlock<ReactionChamberEntity> {
    public static final BooleanProperty WORKING = BooleanProperty.create((String)"working");

    public ReactionChamberBlock() {
        super(ReactionChamberBlock.metalProps().noOcclusion());
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)WORKING, (Comparable)Boolean.valueOf(false)));
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ReactionChamberEntity) {
            ReactionChamberEntity be = (ReactionChamberEntity)blockEntity;
            if (!level.isClientSide()) {
                MenuOpener.open(AAEMenus.REACTION_CHAMBER.get(), (Player)player, (MenuHostLocator)MenuLocators.forBlockEntity((BlockEntity)be));
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return super.useWithoutItem(state, level, pos, player, hitResult);
    }

    protected ItemInteractionResult useItemOn(ItemStack heldItem, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        Item item = heldItem.getItem();
        if (item instanceof BucketItem) {
            BucketItem bucket = (BucketItem)item;
            boolean didSomething = this.useBucket(player, level, pos, heldItem, hand);
            if (didSomething) {
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
            }
        }
        return super.useItemOn(heldItem, state, level, pos, player, hand, hit);
    }

    public boolean useBucket(Player player, Level level, BlockPos pos, ItemStack stack, InteractionHand hand) {
        boolean didSomething = false;
        IFluidHandlerItem cap = (IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM);
        IFluidHandler blockCap = (IFluidHandler)level.getCapability(Capabilities.FluidHandler.BLOCK, pos, null);
        if (cap == null || blockCap == null) {
            return didSomething;
        }
        if (cap.getFluidInTank(0).isEmpty()) {
            FluidStack extracted = blockCap.drain(1000, IFluidHandler.FluidAction.SIMULATE);
            if (!extracted.isEmpty() && extracted.getAmount() == 1000) {
                blockCap.drain(1000, IFluidHandler.FluidAction.EXECUTE);
                if (cap.getContainer().getCount() == 1) {
                    cap.fill(extracted, IFluidHandler.FluidAction.EXECUTE);
                    player.setItemInHand(hand, cap.getContainer());
                } else {
                    ItemStack newBucket = new ItemStack((ItemLike)Items.BUCKET, 1);
                    IFluidHandlerItem newCap = (IFluidHandlerItem)newBucket.getCapability(Capabilities.FluidHandler.ITEM);
                    if (newCap != null) {
                        newCap.fill(extracted, IFluidHandler.FluidAction.EXECUTE);
                        player.setItemInHand(hand, newCap.getContainer());
                        player.addItem(new ItemStack((ItemLike)stack.getItem(), stack.getCount() - 1));
                    }
                }
                SoundEvent soundevent = extracted.getFluidType().getSound(player, (BlockGetter)level, pos, SoundActions.BUCKET_EMPTY);
                if (soundevent == null) {
                    soundevent = extracted.is(FluidTags.LAVA) ? SoundEvents.BUCKET_FILL_LAVA : SoundEvents.BUCKET_FILL;
                }
                level.playSound(player, pos, soundevent, SoundSource.BLOCKS, 1.0f, 1.0f);
                didSomething = true;
            }
        } else {
            FluidStack extracted = cap.drain(1000, IFluidHandler.FluidAction.SIMULATE);
            int inserted = blockCap.fill(extracted, IFluidHandler.FluidAction.SIMULATE);
            if (inserted == 1000) {
                extracted = cap.drain(1000, IFluidHandler.FluidAction.EXECUTE);
                blockCap.fill(extracted, IFluidHandler.FluidAction.EXECUTE);
                didSomething = true;
                player.setItemInHand(hand, cap.getContainer());
                SoundEvent soundevent = extracted.getFluidType().getSound(player, (BlockGetter)level, pos, SoundActions.BUCKET_EMPTY);
                if (soundevent == null) {
                    soundevent = extracted.is(FluidTags.LAVA) ? SoundEvents.BUCKET_EMPTY_LAVA : SoundEvents.BUCKET_EMPTY;
                }
                level.playSound(player, pos, soundevent, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
        return didSomething;
    }

    protected void createBlockStateDefinition(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{WORKING});
    }

    public IOrientationStrategy getOrientationStrategy() {
        return OrientationStrategies.horizontalFacing();
    }
}

