/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.appliedenergistics;

import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEKey;
import appeng.api.storage.MEStorage;
import de.srendi.advancedperipherals.common.addons.appliedenergistics.AEApi;
import de.srendi.advancedperipherals.common.util.Pair;
import de.srendi.advancedperipherals.common.util.inventory.ChemicalFilter;
import de.srendi.advancedperipherals.common.util.inventory.IStorageSystemChemicalHandler;
import de.srendi.advancedperipherals.common.util.inventory.StorageProcessor;
import java.util.List;
import me.ramidzkh.mekae2.ae2.MekanismKey;
import mekanism.api.Action;
import mekanism.api.chemical.ChemicalStack;
import org.jetbrains.annotations.NotNull;

public class MEChemicalHandler
implements IStorageSystemChemicalHandler {
    @NotNull
    private final MEStorage storageMonitor;
    @NotNull
    private final IActionSource actionSource;

    public MEChemicalHandler(@NotNull MEStorage storageMonitor, @NotNull IActionSource actionSource) {
        this.storageMonitor = storageMonitor;
        this.actionSource = actionSource;
    }

    @Override
    @NotNull
    public ChemicalStack insertChemical(ChemicalStack resource, @NotNull Action action) {
        if (resource.isEmpty()) {
            return resource;
        }
        ChemicalStack remain = resource.copy();
        long amountInserted = this.storageMonitor.insert((AEKey)MekanismKey.of((ChemicalStack)resource), resource.getAmount(), action.simulate() ? Actionable.SIMULATE : Actionable.MODULATE, this.actionSource);
        remain.setAmount(resource.getAmount() - amountInserted);
        return remain;
    }

    @Override
    public long extractChemicals(ChemicalFilter filter, StorageProcessor.Large<ChemicalStack> processor, Action action) {
        List<Pair<Long, MekanismKey>> chemicalKeys = AEApi.findAEChemicalsFromFilter(this.storageMonitor, filter);
        if (chemicalKeys.isEmpty()) {
            return 0L;
        }
        long needs = filter.getAmount();
        for (Pair<Long, MekanismKey> pair : chemicalKeys) {
            long extracted;
            MekanismKey chemicalKey = pair.right();
            long amount = this.storageMonitor.extract((AEKey)chemicalKey, needs, Actionable.SIMULATE, this.actionSource);
            if (amount == 0L || (extracted = processor.process(chemicalKey.getStack().copyWithAmount(amount))) == 0L) continue;
            needs -= extracted;
            if (action.execute()) {
                this.storageMonitor.extract((AEKey)chemicalKey, extracted, Actionable.MODULATE, this.actionSource);
            }
            if (needs > 0L) continue;
            break;
        }
        return filter.getAmount() - needs;
    }
}

