/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.computercraft.integrations;

import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.lua.GenericSource;
import dan200.computercraft.api.peripheral.PeripheralCapability;
import de.srendi.advancedperipherals.AdvancedPeripherals;
import de.srendi.advancedperipherals.common.addons.computercraft.integrations.BeaconIntegration;
import de.srendi.advancedperipherals.common.addons.computercraft.integrations.NoteBlockIntegration;
import de.srendi.advancedperipherals.common.util.Platform;
import java.util.Optional;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;

public class IntegrationPeripheralProvider {
    private static final String[] SUPPORTED_MODS = new String[]{"mekanism", "powah"};

    public static void load() {
        ComputerCraftAPI.registerGenericSource((GenericSource)new BeaconIntegration());
        for (String mod : SUPPORTED_MODS) {
            Optional<Object> integration = Platform.maybeLoadIntegration(mod, mod + ".Integration");
            if (integration.isEmpty()) {
                AdvancedPeripherals.LOGGER.warn("Failed to load integration for {}", (Object)mod);
                continue;
            }
            Runnable runnable = (Runnable)integration.get();
            AdvancedPeripherals.LOGGER.info("Successfully loaded integration for {}", (Object)mod);
            runnable.run();
        }
    }

    public static void registerBlockIntegrations(RegisterCapabilitiesEvent event) {
        event.registerBlock(PeripheralCapability.get(), (level, pos, state, blockEntity, side) -> new NoteBlockIntegration(level, pos), new Block[]{Blocks.NOTE_BLOCK});
    }
}

