/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.computercraft.peripheral;

import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleSide;
import de.srendi.advancedperipherals.common.addons.computercraft.owner.TurtlePeripheralOwner;
import de.srendi.advancedperipherals.common.configuration.APConfig;
import de.srendi.advancedperipherals.common.setup.DataComponents;
import de.srendi.advancedperipherals.common.util.ChunkManager;
import de.srendi.advancedperipherals.lib.peripherals.BasePeripheral;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChunkyPeripheral
extends BasePeripheral<TurtlePeripheralOwner> {
    public static final String PERIPHERAL_TYPE = "chunky";
    @Nullable
    private ChunkPos loadedCentralChunk = null;

    public ChunkyPeripheral(ITurtleAccess turtle, TurtleSide side) {
        super(PERIPHERAL_TYPE, new TurtlePeripheralOwner(turtle, side));
    }

    protected UUID getUUID() {
        PatchedDataComponentMap patch = PatchedDataComponentMap.fromPatch((DataComponentMap)DataComponentMap.EMPTY, (DataComponentPatch)((TurtlePeripheralOwner)this.owner).getDataStorage());
        if (!patch.has((DataComponentType)DataComponents.CHUNKY_ID.get())) {
            patch.set((DataComponentType)DataComponents.CHUNKY_ID.get(), (Object)UUID.randomUUID());
            ((TurtlePeripheralOwner)this.owner).putDataStorage(patch.asPatch());
        }
        return (UUID)patch.get((DataComponentType)DataComponents.CHUNKY_ID.get());
    }

    public ChunkPos getChunkPos() {
        return this.getLevel().getChunkAt(this.getPos()).getPos();
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)APConfig.PERIPHERALS_CONFIG.enableChunkyTurtle.get();
    }

    public void updateChunkState() {
        ServerLevel level = (ServerLevel)this.getLevel();
        ChunkManager manager = ChunkManager.get(level);
        ChunkPos currentChunk = this.getChunkPos();
        this.setLoadedChunk(currentChunk, manager, level);
        manager.touch(this.getUUID());
    }

    protected void setLoadedChunk(@Nullable ChunkPos newChunk, ChunkManager manager, ServerLevel level) {
        if (this.loadedCentralChunk != null) {
            if (this.loadedCentralChunk.equals((Object)newChunk)) {
                return;
            }
            manager.removeForceChunk(level, this.getUUID());
            this.loadedCentralChunk = null;
        }
        if (newChunk != null) {
            this.loadedCentralChunk = newChunk;
            manager.addForceChunk(level, this.getUUID(), this.loadedCentralChunk);
        }
    }

    @Override
    public void attach(IComputerAccess computer) {
        super.attach(computer);
        ServerLevel level = (ServerLevel)((TurtlePeripheralOwner)this.owner).getLevel();
        ChunkManager manager = ChunkManager.get(Objects.requireNonNull(level));
        ChunkPos currentChunk = this.getChunkPos();
        this.setLoadedChunk(currentChunk, manager, level);
    }

    @Override
    public void detach(@NotNull IComputerAccess computer) {
        super.detach(computer);
    }
}

