/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.blocks.blockentities;

import com.refinedmods.refinedstorage.api.autocrafting.status.TaskStatus;
import com.refinedmods.refinedstorage.api.autocrafting.status.TaskStatusListener;
import com.refinedmods.refinedstorage.api.autocrafting.task.TaskId;
import com.refinedmods.refinedstorage.api.network.autocrafting.AutocraftingNetworkComponent;
import com.refinedmods.refinedstorage.api.network.impl.node.SimpleNetworkNode;
import com.refinedmods.refinedstorage.api.network.node.NetworkNode;
import com.refinedmods.refinedstorage.common.api.support.network.ConnectionStrategy;
import com.refinedmods.refinedstorage.common.api.support.network.InWorldNetworkNodeContainer;
import com.refinedmods.refinedstorage.common.api.support.network.NetworkNodeContainerProvider;
import com.refinedmods.refinedstorage.common.support.network.InWorldNetworkNodeContainerImpl;
import com.refinedmods.refinedstorage.common.support.network.SimpleConnectionStrategy;
import de.srendi.advancedperipherals.common.addons.computercraft.peripheral.RSBridgePeripheral;
import de.srendi.advancedperipherals.common.addons.refinedstorage.RSCraftJob;
import de.srendi.advancedperipherals.common.blocks.base.PeripheralBlockEntity;
import de.srendi.advancedperipherals.common.configuration.APConfig;
import de.srendi.advancedperipherals.common.setup.BlockEntityTypes;
import de.srendi.advancedperipherals.common.util.inventory.BasicCraftJob;
import de.srendi.advancedperipherals.lib.peripherals.IPeripheralTileEntity;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class RSBridgeEntity
extends PeripheralBlockEntity<RSBridgePeripheral>
implements IPeripheralTileEntity,
NetworkNodeContainerProvider,
TaskStatusListener {
    protected CompoundTag peripheralSettings;
    private final NetworkNode node;
    private final InWorldNetworkNodeContainer networkNodeContainer;
    private final List<RSCraftJob> jobs = new CopyOnWriteArrayList<RSCraftJob>();
    private boolean addedListener = false;

    public RSBridgeEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityTypes.RS_BRIDGE.get(), pos, state);
        this.peripheralSettings = new CompoundTag();
        SimpleConnectionStrategy connectionStrategy = new SimpleConnectionStrategy(pos);
        this.node = new SimpleNetworkNode((long)((Integer)APConfig.PERIPHERALS_CONFIG.rsConsumption.get()).intValue());
        this.networkNodeContainer = new InWorldNetworkNodeContainerImpl((BlockEntity)this, this.node, "RS Bridge", 1, (ConnectionStrategy)connectionStrategy, null);
    }

    @Override
    @NotNull
    protected RSBridgePeripheral createPeripheral() {
        return new RSBridgePeripheral(this);
    }

    @Override
    public CompoundTag getPeripheralSettings() {
        return this.peripheralSettings;
    }

    @Override
    public void markSettingsChanged() {
        this.setChanged();
    }

    @Override
    public <T extends BlockEntity> void handleTick(Level level, BlockState state, BlockEntityType<T> type) {
        if (this.getNode().getNetwork() != null) {
            AutocraftingNetworkComponent manager = (AutocraftingNetworkComponent)this.getNode().getNetwork().getComponent(AutocraftingNetworkComponent.class);
            if (!this.addedListener) {
                manager.addListener((TaskStatusListener)this);
                this.addedListener = true;
            }
        }
        this.jobs.forEach(BasicCraftJob::tick);
        this.jobs.removeIf(BasicCraftJob::canBePurged);
    }

    public void addJob(RSCraftJob job) {
        this.jobs.add(job);
    }

    public List<RSCraftJob> getJobs() {
        return this.jobs;
    }

    public NetworkNode getNode() {
        return this.node;
    }

    public void clearRemoved() {
        super.clearRemoved();
        this.initialize(this.level, null);
    }

    @NotNull
    public Set<InWorldNetworkNodeContainer> getContainers() {
        return Set.of(this.networkNodeContainer);
    }

    public void addContainer(@NotNull InWorldNetworkNodeContainer inWorldNetworkNodeContainer) {
    }

    public boolean canBuild(@NotNull ServerPlayer serverPlayer) {
        return true;
    }

    public void taskStatusChanged(@NotNull TaskStatus taskStatus) {
        this.jobs.stream().filter(BasicCraftJob::isCraftingStarted).filter(job -> job.getCraftingTask().info().id().equals((Object)taskStatus.info().id())).forEach(BasicCraftJob::jobStateChanged);
    }

    public void taskRemoved(@NotNull TaskId taskId) {
        this.jobs.stream().filter(BasicCraftJob::isCraftingStarted).filter(job -> job.getCraftingTask().info().id().equals((Object)taskId)).forEach(BasicCraftJob::jobStateChanged);
    }

    public void taskAdded(@NotNull TaskStatus taskStatus) {
        this.jobs.stream().filter(BasicCraftJob::isCraftingStarted).filter(job -> job.getCraftingTask().info().id().equals((Object)taskStatus.info().id())).forEach(BasicCraftJob::jobStateChanged);
    }
}

