/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.items;

import de.srendi.advancedperipherals.common.configuration.APConfig;
import de.srendi.advancedperipherals.common.items.APItem;
import de.srendi.advancedperipherals.common.setup.DataComponents;
import de.srendi.advancedperipherals.common.setup.Items;
import de.srendi.advancedperipherals.common.util.EnumColor;
import de.srendi.advancedperipherals.lib.metaphysics.IFeedableAutomataCore;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.util.FakePlayer;
import org.jetbrains.annotations.NotNull;

public class WeakAutomataCore
extends APItem
implements IFeedableAutomataCore {
    private static final String CONSUMED_ENTITY_COUNT = "consumed_entity_count";
    private static final String CONSUMED_ENTITY_NAME = "consumed_entity_name";
    private static final Map<String, WeakAutomataCoreRecord> AUTOMATA_CORE_REGISTRY = new HashMap<String, WeakAutomataCoreRecord>();

    public WeakAutomataCore(Item.Properties properties) {
        super(properties, (Supplier<Boolean>)APConfig.METAPHYSICS_CONFIG.enableWeakAutomataCore);
    }

    public WeakAutomataCore() {
        super((Supplier<Boolean>)APConfig.METAPHYSICS_CONFIG.enableWeakAutomataCore);
    }

    @Override
    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        CompoundTag consumedData = (CompoundTag)stack.get((DataComponentType)DataComponents.CONSUMED_ENTITY_COMPOUND.get());
        if (consumedData != null) {
            consumedData.getAllKeys().forEach(key -> {
                WeakAutomataCoreRecord record = AUTOMATA_CORE_REGISTRY.get(key);
                CompoundTag recordData = consumedData.getCompound(key);
                tooltip.add(EnumColor.buildTextComponent((Component)Component.literal((String)String.format("Consumed: %d/%d %s", recordData.getInt(CONSUMED_ENTITY_COUNT), record.getRequiredCount((String)key), recordData.getString(CONSUMED_ENTITY_NAME)))));
            });
        }
    }

    @NotNull
    public InteractionResult interactLivingEntity(@NotNull ItemStack stack, @NotNull Player player, @NotNull LivingEntity entity, @NotNull InteractionHand hand) {
        if (!(player instanceof FakePlayer)) {
            player.displayClientMessage((Component)Component.translatable((String)"text.advancedperipherals.automata_core_feed_by_player"), true);
            return InteractionResult.FAIL;
        }
        String entityType = EntityType.getKey((EntityType)entity.getType()).toString();
        if (AUTOMATA_CORE_REGISTRY.containsKey(entityType)) {
            WeakAutomataCoreRecord record;
            CompoundTag consumedData;
            CompoundTag compoundTag = consumedData = stack.get(DataComponents.CONSUMED_ENTITY_COMPOUND) == null ? new CompoundTag() : (CompoundTag)stack.get(DataComponents.CONSUMED_ENTITY_COMPOUND);
            if (consumedData == null) {
                return InteractionResult.PASS;
            }
            if (consumedData.isEmpty()) {
                record = AUTOMATA_CORE_REGISTRY.get(entityType);
            } else {
                Optional anyKey = consumedData.getAllKeys().stream().findAny();
                if (!anyKey.isPresent()) {
                    return InteractionResult.PASS;
                }
                record = AUTOMATA_CORE_REGISTRY.get(anyKey.get());
            }
            if (!record.isSuitable(entityType, consumedData)) {
                return InteractionResult.PASS;
            }
            entity.remove(Entity.RemovalReason.KILLED);
            CompoundTag entityCompound = consumedData.getCompound(entityType);
            entityCompound.putInt(CONSUMED_ENTITY_COUNT, entityCompound.getInt(CONSUMED_ENTITY_COUNT) + 1);
            entityCompound.putString(CONSUMED_ENTITY_NAME, entity.getName().getString());
            consumedData.put(entityType, (Tag)entityCompound);
            if (record.isFinished(consumedData)) {
                player.setItemInHand(hand, new ItemStack((ItemLike)record.resultSoul));
            }
            stack.set((DataComponentType)DataComponents.CONSUMED_ENTITY_COMPOUND.get(), (Object)consumedData);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    static {
        HashMap<String, Integer> endSouls = new HashMap<String, Integer>();
        endSouls.put(BuiltInRegistries.ENTITY_TYPE.getKey((Object)EntityType.ENDERMAN).toString(), 10);
        WeakAutomataCoreRecord endSoulRecord = new WeakAutomataCoreRecord(endSouls, (Item)Items.END_AUTOMATA_CORE.get());
        HashMap<String, Integer> husbandrySouls = new HashMap<String, Integer>();
        husbandrySouls.put(BuiltInRegistries.ENTITY_TYPE.getKey((Object)EntityType.COW).toString(), 3);
        husbandrySouls.put(BuiltInRegistries.ENTITY_TYPE.getKey((Object)EntityType.SHEEP).toString(), 3);
        husbandrySouls.put(BuiltInRegistries.ENTITY_TYPE.getKey((Object)EntityType.CHICKEN).toString(), 3);
        WeakAutomataCoreRecord husbandrySoulRecord = new WeakAutomataCoreRecord(husbandrySouls, (Item)Items.HUSBANDRY_AUTOMATA_CORE.get());
        endSoulRecord.ingredients.keySet().forEach(entityType -> AUTOMATA_CORE_REGISTRY.put((String)entityType, endSoulRecord));
        husbandrySoulRecord.ingredients.keySet().forEach(entityType -> AUTOMATA_CORE_REGISTRY.put((String)entityType, husbandrySoulRecord));
    }

    public record WeakAutomataCoreRecord(Map<String, Integer> ingredients, Item resultSoul) {
        public int getRequiredCount(String entityType) {
            return this.ingredients.getOrDefault(entityType, 0);
        }

        public boolean isSuitable(String entityType, CompoundTag consumedData) {
            if (!this.ingredients.containsKey(entityType)) {
                return false;
            }
            int requiredCount = this.ingredients.get(entityType);
            int currentCount = consumedData.getCompound(entityType).getInt(WeakAutomataCore.CONSUMED_ENTITY_COUNT);
            return currentCount < requiredCount;
        }

        public boolean isFinished(CompoundTag consumedData) {
            return this.ingredients.entrySet().stream().map(entry -> ((Integer)entry.getValue()).intValue() == consumedData.getCompound((String)entry.getKey()).getInt(WeakAutomataCore.CONSUMED_ENTITY_COUNT)).reduce((a, b) -> a != false && b != false).orElse(true);
        }
    }
}

