/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.items.base;

import de.srendi.advancedperipherals.client.KeyBindings;
import de.srendi.advancedperipherals.common.util.EnumColor;
import de.srendi.advancedperipherals.common.util.KeybindUtil;
import de.srendi.advancedperipherals.common.util.TranslationUtil;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public abstract class BaseBlockItem
extends BlockItem {
    private Component description;

    public BaseBlockItem(Block blockIn, Item.Properties properties) {
        super(blockIn, properties);
    }

    public BaseBlockItem(Block blockIn) {
        super(blockIn, new Item.Properties());
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        if (!KeybindUtil.isKeyPressed(KeyBindings.DESCRIPTION_KEYBINDING)) {
            tooltip.add(EnumColor.buildTextComponent((Component)Component.translatable((String)"item.advancedperipherals.tooltip.show_desc", (Object[])new Object[]{KeyBindings.DESCRIPTION_KEYBINDING.getTranslatedKeyMessage()})));
        } else {
            tooltip.add(EnumColor.buildTextComponent(this.getDescription()));
        }
        if (!this.isEnabled()) {
            tooltip.add(EnumColor.buildTextComponent((Component)Component.translatable((String)"item.advancedperipherals.tooltip.disabled")));
        }
    }

    @NotNull
    public Component getDescription() {
        if (this.description == null) {
            this.description = TranslationUtil.itemTooltip(this.getDescriptionId());
        }
        return this.description;
    }

    public abstract boolean isEnabled();
}

