/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.data;

import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.loot.AffixLootEntry;
import dev.shadowsoffire.apotheosis.loot.AffixLootRegistry;
import dev.shadowsoffire.apotheosis.loot.LootCategory;
import dev.shadowsoffire.apotheosis.tiers.TieredWeights;
import dev.shadowsoffire.apotheosis.tiers.WorldTier;
import dev.shadowsoffire.placebo.reload.DynamicRegistry;
import dev.shadowsoffire.placebo.util.data.DynamicRegistryProvider;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.ItemLike;

public class AffixLootEntryProvider
extends DynamicRegistryProvider<AffixLootEntry> {
    protected static final TieredWeights STONE = TieredWeights.onlyFor(WorldTier.HAVEN, 25, 0.0f);
    protected static final TieredWeights LEATHER = TieredWeights.onlyFor(WorldTier.HAVEN, 25, 0.0f);
    protected static final TieredWeights CHAIN = TieredWeights.builder().with(WorldTier.HAVEN, 10, 0.0f).with(WorldTier.FRONTIER, 10, 1.0f).build();
    protected static final TieredWeights GOLD = TieredWeights.builder().with(WorldTier.HAVEN, 5, 0.0f).with(WorldTier.FRONTIER, 10, 0.0f).with(WorldTier.ASCENT, 5, 0.0f).build();
    protected static final TieredWeights IRON = TieredWeights.builder().with(WorldTier.FRONTIER, 25, 1.0f).with(WorldTier.ASCENT, 10, 0.0f).with(WorldTier.SUMMIT, 10, 0.0f).build();
    protected static final TieredWeights DIAMOND = TieredWeights.builder().with(WorldTier.ASCENT, 25, 0.0f).with(WorldTier.SUMMIT, 25, 0.0f).with(WorldTier.PINNACLE, 5, 0.0f).build();
    protected static final TieredWeights NETHERITE = TieredWeights.builder().with(WorldTier.SUMMIT, 5, 1.0f).with(WorldTier.PINNACLE, 25, 2.0f).build();
    protected static final TieredWeights TRIDENT = TieredWeights.builder().with(WorldTier.ASCENT, 5, 1.0f).with(WorldTier.SUMMIT, 7, 1.0f).with(WorldTier.PINNACLE, 7, 1.0f).build();

    public AffixLootEntryProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries, (DynamicRegistry)AffixLootRegistry.INSTANCE);
    }

    public String getName() {
        return "Affix Loot Entries";
    }

    public void generate() {
        HashMap<Holder, TieredWeights> armorWeights = new HashMap<Holder, TieredWeights>();
        armorWeights.put(ArmorMaterials.LEATHER, LEATHER);
        armorWeights.put(ArmorMaterials.CHAIN, CHAIN);
        armorWeights.put(ArmorMaterials.GOLD, GOLD);
        armorWeights.put(ArmorMaterials.IRON, IRON);
        armorWeights.put(ArmorMaterials.DIAMOND, DIAMOND);
        armorWeights.put(ArmorMaterials.NETHERITE, NETHERITE);
        block7: for (Item i : BuiltInRegistries.ITEM) {
            TieredWeights weights;
            ArmorItem a;
            TieredItem t;
            Tier tier;
            LootCategory cat;
            if (!"minecraft".equals(BuiltInRegistries.ITEM.getKey((Object)i).getNamespace()) || (cat = LootCategory.forItem(i.getDefaultInstance())).isNone()) continue;
            if (i instanceof TieredItem && (tier = (t = (TieredItem)i).getTier()) instanceof Tiers) {
                Tiers tier2 = (Tiers)tier;
                switch (tier2) {
                    case STONE: {
                        this.addEntry(new AffixLootEntry(STONE, new ItemStack((ItemLike)i)));
                        continue block7;
                    }
                    case GOLD: {
                        this.addEntry(new AffixLootEntry(GOLD, new ItemStack((ItemLike)i)));
                        continue block7;
                    }
                    case IRON: {
                        this.addEntry(new AffixLootEntry(IRON, new ItemStack((ItemLike)i)));
                        continue block7;
                    }
                    case DIAMOND: {
                        this.addEntry(new AffixLootEntry(DIAMOND, new ItemStack((ItemLike)i)));
                        continue block7;
                    }
                    case NETHERITE: {
                        this.addEntry(new AffixLootEntry(NETHERITE, new ItemStack((ItemLike)i)));
                        continue block7;
                    }
                }
                continue;
            }
            if (!(i instanceof ArmorItem) || (a = (ArmorItem)i).getType() == ArmorItem.Type.BODY || (weights = (TieredWeights)armorWeights.get(a.getMaterial())) == null) continue;
            this.addEntry(new AffixLootEntry(weights, new ItemStack((ItemLike)i)));
        }
        this.addEntry(new AffixLootEntry(TieredWeights.forAllTiers(5, 1.0f), new ItemStack((ItemLike)Items.BOW)));
        this.addEntry(new AffixLootEntry(TieredWeights.forAllTiers(5, 1.0f), new ItemStack((ItemLike)Items.CROSSBOW)));
        this.addEntry(new AffixLootEntry(TieredWeights.forAllTiers(5, 1.0f), new ItemStack((ItemLike)Items.SHIELD)));
        this.addEntry(new AffixLootEntry(TRIDENT, new ItemStack((ItemLike)Items.TRIDENT)));
        this.addEntry(new AffixLootEntry(TieredWeights.forAllTiers(2, 0.0f), new ItemStack((ItemLike)Items.TURTLE_HELMET)));
    }

    protected void addEntry(AffixLootEntry entry) {
        this.add(Apotheosis.loc(BuiltInRegistries.ITEM.getKey((Object)entry.stack().getItem()).getPath()), entry);
    }
}

