/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.socket.gem;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.affix.Affix;
import dev.shadowsoffire.apotheosis.loot.LootCategory;
import dev.shadowsoffire.apotheosis.socket.SocketHelper;
import dev.shadowsoffire.apotheosis.socket.gem.GemClass;
import dev.shadowsoffire.apotheosis.socket.gem.GemInstance;
import dev.shadowsoffire.apotheosis.socket.gem.GemItem;
import dev.shadowsoffire.apotheosis.socket.gem.GemRegistry;
import dev.shadowsoffire.apotheosis.socket.gem.GemView;
import dev.shadowsoffire.apotheosis.socket.gem.Purity;
import dev.shadowsoffire.apotheosis.socket.gem.bonus.GemBonus;
import dev.shadowsoffire.apotheosis.tiers.Constraints;
import dev.shadowsoffire.apotheosis.tiers.TieredWeights;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.util.AttributeTooltipContext;

public class Gem
implements CodecProvider<Gem>,
TieredWeights.Weighted,
Constraints.Constrained {
    public static final Codec<Gem> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)TieredWeights.CODEC.fieldOf("weights").forGetter(TieredWeights.Weighted::weights), (App)Constraints.CODEC.optionalFieldOf("constraints", (Object)Constraints.EMPTY).forGetter(Constraints.Constrained::constraints), (App)Purity.CODEC.optionalFieldOf("min_purity", (Object)Purity.CRACKED).forGetter(Gem::getMinPurity), (App)GemBonus.CODEC.listOf().fieldOf("bonuses").forGetter(Gem::getBonuses), (App)Codec.BOOL.optionalFieldOf("unique", (Object)false).forGetter(Gem::isUnique)).apply((Applicative)inst, Gem::new));
    protected final TieredWeights weights;
    protected final Constraints constraints;
    protected final Purity minPurity;
    protected final List<GemBonus> bonuses;
    protected final boolean unique;
    protected final transient Map<LootCategory, GemBonus> bonusMap = new IdentityHashMap<LootCategory, GemBonus>();
    protected final transient List<GemBonus> extraBonuses = new ArrayList<GemBonus>();

    public Gem(TieredWeights weights, Constraints constraints, Purity minPurity, List<GemBonus> bonuses, boolean unique) {
        this.weights = weights;
        this.constraints = constraints;
        this.minPurity = minPurity;
        this.bonuses = bonuses;
        this.unique = unique;
        Preconditions.checkArgument((!bonuses.isEmpty() ? 1 : 0) != 0, (Object)"No bonuses were provided.");
        for (GemBonus bonus : this.bonuses) {
            this.validateBonus(bonus);
            for (Holder category : bonus.getGemClass().types()) {
                this.bonusMap.put((LootCategory)category.value(), bonus);
            }
        }
    }

    public void addInformation(GemView gem, Consumer<Component> list, AttributeTooltipContext ctx) {
        if (this.isUnique()) {
            list.accept((Component)Component.translatable((String)"text.apotheosis.unique").withStyle(Style.EMPTY.withColor(13056274)));
            list.accept(CommonComponents.EMPTY);
        }
        Style style = Style.EMPTY.withColor(720650);
        list.accept((Component)Component.translatable((String)"text.apotheosis.socketable_into").withStyle(style));
        Gem.addTypeInfo(list, this.bonusMap.keySet().toArray());
        list.accept(CommonComponents.EMPTY);
        list.accept((Component)Component.translatable((String)"text.apotheosis.when_socketed_in").withStyle(ChatFormatting.GOLD));
        Consumer<GemBonus> appendBonusToTooltip = bonus -> {
            if (bonus.supports(gem.purity())) {
                Component modifComp = bonus.getSocketBonusTooltip(gem, ctx);
                MutableComponent sum = Component.translatable((String)"text.apotheosis.dot_prefix", (Object[])new Object[]{Component.translatable((String)"%s: %s", (Object[])new Object[]{Component.translatable((String)("gem_class." + bonus.getGemClass().key())), modifComp})}).withStyle(ChatFormatting.GOLD);
                list.accept((Component)sum);
            }
        };
        this.bonuses.forEach(appendBonusToTooltip);
        this.extraBonuses.forEach(appendBonusToTooltip);
    }

    public boolean canApplyTo(ItemStack socketed, ItemStack gem, Purity purity) {
        List<Gem> gems;
        if (this.isUnique() && (gems = SocketHelper.getGems(socketed).streamValidGems().map(GemInstance::gem).map(DynamicHolder::get).toList()).contains(this)) {
            return false;
        }
        return this.isValidIn(socketed, gem, purity);
    }

    public boolean isValidIn(ItemStack socketed, ItemStack gem, Purity purity) {
        LootCategory cat = LootCategory.forItem(socketed);
        return !cat.isNone() && this.bonusMap.containsKey(cat) && this.bonusMap.get(cat).supports(purity);
    }

    public Optional<GemBonus> getBonus(LootCategory cat, Purity purity) {
        return Optional.ofNullable(this.bonusMap.get(cat)).filter(b -> b.supports(purity));
    }

    public String toString() {
        return String.format("Gem: %s", this.getId());
    }

    @Override
    public TieredWeights weights() {
        return this.weights;
    }

    @Override
    public Constraints constraints() {
        return this.constraints;
    }

    public Purity getMinPurity() {
        return this.minPurity;
    }

    @Deprecated(forRemoval=true)
    public List<GemBonus> getBonuses() {
        return this.bonuses;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public Codec<? extends Gem> getCodec() {
        return CODEC;
    }

    public final ResourceLocation getId() {
        return GemRegistry.INSTANCE.getKey(this);
    }

    public ItemStack toStack(Purity purity) {
        ItemStack stack = new ItemStack(Apoth.Items.GEM);
        GemItem.setGem(stack, this);
        GemItem.setPurity(stack, Purity.max(purity, this.getMinPurity()));
        return stack;
    }

    public static String fmt(float f) {
        return Affix.fmt(f);
    }

    public static void addTypeInfo(Consumer<Component> list, Object ... types) {
        Arrays.sort(types, (c1, c2) -> ((LootCategory)c1).getKey().compareTo(((LootCategory)c2).getKey()));
        Style style = Style.EMPTY.withColor(720650);
        if (types.length < Apoth.BuiltInRegs.LOOT_CATEGORY.size() - 1) {
            int rem;
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < types.length; i += rem) {
                rem = Math.min(3, types.length - i);
                Object[] args = new Object[rem];
                for (int r = 0; r < rem; ++r) {
                    sb.append("%s, ");
                    args[r] = Component.translatable((String)((LootCategory)types[i + r]).getDescIdPlural());
                }
                list.accept((Component)Component.translatable((String)"text.apotheosis.dot_prefix", (Object[])new Object[]{Component.translatable((String)sb.substring(0, sb.length() - 2), (Object[])args)}).withStyle(style));
                sb.setLength(0);
            }
        } else {
            list.accept((Component)Component.translatable((String)"text.apotheosis.dot_prefix", (Object[])new Object[]{Component.translatable((String)"text.apotheosis.anything")}).withStyle(style));
        }
    }

    private void validateBonus(GemBonus bonus) {
        for (Holder category : bonus.getGemClass().types()) {
            if (!this.bonusMap.containsKey(category.value())) continue;
            GemBonus conflict = this.bonusMap.get(category.value());
            throw new IllegalArgumentException("Gem Bonus for class %s conflicts with existing bonus for class %s (categories overlap)".formatted(bonus.getGemClass().key(), conflict.getGemClass().key()));
        }
    }

    void appendExtraBonus(GemBonus bonus) {
        this.validateBonus(bonus);
        this.extraBonuses.add(bonus);
        for (Holder category : bonus.getGemClass().types()) {
            this.bonusMap.put((LootCategory)category.value(), bonus);
        }
    }

    public static class Builder {
        protected final TieredWeights weights;
        protected Constraints constraints = Constraints.EMPTY;
        protected Purity minPurity = Purity.CRACKED;
        protected List<GemBonus> bonuses = new ArrayList<GemBonus>();
        protected boolean unique = false;

        public Builder(TieredWeights weights) {
            this.weights = weights;
        }

        public Builder contstraints(Constraints constraints) {
            this.constraints = constraints;
            return this;
        }

        public Builder minPurity(Purity purity) {
            this.minPurity = purity;
            return this;
        }

        public Builder bonus(LootCategory cat, GemBonus.Builder builder) {
            return this.bonus(new GemClass(cat), builder);
        }

        public Builder bonus(GemClass gClass, GemBonus.Builder builder) {
            this.bonuses.add(builder.build(gClass));
            return this;
        }

        public Builder bonus(GemBonus bonus) {
            this.bonuses.add(bonus);
            return this;
        }

        public Builder unique() {
            this.unique = true;
            return this;
        }

        public Gem build() {
            return new Gem(this.weights, this.constraints, this.minPurity, this.bonuses, this.unique);
        }
    }
}

