/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_spawners.stats;

import dev.shadowsoffire.apothic_spawners.ApothicSpawners;
import dev.shadowsoffire.apothic_spawners.block.ApothSpawnerTile;
import dev.shadowsoffire.apothic_spawners.stats.BooleanStat;
import dev.shadowsoffire.apothic_spawners.stats.LevelStat;
import dev.shadowsoffire.apothic_spawners.stats.PercentageStat;
import dev.shadowsoffire.apothic_spawners.stats.SpawnerStat;
import dev.shadowsoffire.apothic_spawners.stats.VanillaStat;
import java.util.function.Consumer;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.registries.RegistryBuilder;

public class SpawnerStats {
    public static final Registry<SpawnerStat<?>> REGISTRY = new RegistryBuilder(ResourceKey.createRegistryKey((ResourceLocation)ApothicSpawners.loc("spawner_stat"))).create();
    public static final SpawnerStat<Integer> MIN_DELAY = SpawnerStats.register("min_delay", new VanillaStat(s -> s.spawner.minSpawnDelay, (s, v) -> {
        s.spawner.minSpawnDelay = v;
    }));
    public static final SpawnerStat<Integer> MAX_DELAY = SpawnerStats.register("max_delay", new VanillaStat(s -> s.spawner.maxSpawnDelay, (s, v) -> {
        s.spawner.maxSpawnDelay = v;
    }));
    public static final SpawnerStat<Integer> SPAWN_COUNT = SpawnerStats.register("spawn_count", new VanillaStat(s -> s.spawner.spawnCount, (s, v) -> {
        s.spawner.spawnCount = v;
    }));
    public static final SpawnerStat<Integer> MAX_NEARBY_ENTITIES = SpawnerStats.register("max_nearby_entities", new VanillaStat(s -> s.spawner.maxNearbyEntities, (s, v) -> {
        s.spawner.maxNearbyEntities = v;
    }));
    public static final SpawnerStat<Integer> REQ_PLAYER_RANGE = SpawnerStats.register("req_player_range", new VanillaStat(s -> s.spawner.requiredPlayerRange, (s, v) -> {
        s.spawner.requiredPlayerRange = v;
    }));
    public static final SpawnerStat<Integer> SPAWN_RANGE = SpawnerStats.register("spawn_range", new VanillaStat(s -> s.spawner.spawnRange, (s, v) -> {
        s.spawner.spawnRange = v;
    }));
    public static final SpawnerStat<Float> INITIAL_HEALTH = SpawnerStats.register("initial_health", new PercentageStat(Float.valueOf(1.0f)));
    public static final SpawnerStat<Boolean> IGNORE_PLAYERS = SpawnerStats.register("ignore_players", new BooleanStat(false));
    public static final SpawnerStat<Boolean> IGNORE_CONDITIONS = SpawnerStats.register("ignore_conditions", new BooleanStat(false));
    public static final SpawnerStat<Boolean> REDSTONE_CONTROL = SpawnerStats.register("redstone_control", new BooleanStat(false));
    public static final SpawnerStat<Boolean> IGNORE_LIGHT = SpawnerStats.register("ignore_light", new BooleanStat(false));
    public static final SpawnerStat<Boolean> NO_AI = SpawnerStats.register("no_ai", new BooleanStat(false));
    public static final SpawnerStat<Boolean> SILENT = SpawnerStats.register("silent", new BooleanStat(false));
    public static final SpawnerStat<Boolean> YOUTHFUL = SpawnerStats.register("youthful", new BooleanStat(false));
    public static final SpawnerStat<Boolean> BURNING = SpawnerStats.register("burning", new BooleanStat(false));
    public static final SpawnerStat<Integer> ECHOING = SpawnerStats.register("echoing", new LevelStat(0));

    public static void bootstrap() {
    }

    public static void generateTooltip(ApothSpawnerTile tile, Consumer<Component> list) {
        for (SpawnerStat stat : REGISTRY) {
            Component comp = stat.getTooltip(tile);
            if (comp.getString().isEmpty()) continue;
            list.accept(comp);
        }
    }

    private static <T extends SpawnerStat<?>> T register(String id, T t) {
        Registry.register(REGISTRY, (ResourceLocation)ApothicSpawners.loc(id), t);
        return t;
    }
}

