/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.avaritia.block;

import java.util.List;
import net.byAqua3.avaritia.block.BlockMachine;
import net.byAqua3.avaritia.inventory.MenuNeutroniumCompressor;
import net.byAqua3.avaritia.loader.AvaritiaBlocks;
import net.byAqua3.avaritia.tile.TileNeutroniumCompressor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class BlockNeutroniumCompressor
extends BlockMachine {
    public static final Component TITLE = Component.translatable((String)"avaritia:container.neutronium_compressor.title");

    public BlockNeutroniumCompressor(BlockBehaviour.Properties properties) {
        super(properties, () -> AvaritiaBlocks.COMPRESSOR_TILE.get());
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult result) {
        if (level.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof TileNeutroniumCompressor) {
            TileNeutroniumCompressor tile = (TileNeutroniumCompressor)blockEntity;
            SimpleMenuProvider simpleMenuProvider = new SimpleMenuProvider((id, inventory, access) -> new MenuNeutroniumCompressor(id, inventory, tile, tile.dataAccess), TITLE);
            player.openMenu((MenuProvider)simpleMenuProvider, pos);
        }
        return InteractionResult.CONSUME;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        BlockEntity blockEntity;
        if (state.getBlock() != newState.getBlock() && (blockEntity = level.getBlockEntity(pos)) instanceof TileNeutroniumCompressor) {
            TileNeutroniumCompressor tile = (TileNeutroniumCompressor)blockEntity;
            List<NonNullList> itemStacksList = List.of(tile.matrix.getItems(), tile.result.getItems());
            for (NonNullList itemStacks : itemStacksList) {
                for (ItemStack itemStack : itemStacks) {
                    if (itemStack.isEmpty()) continue;
                    ItemEntity itemEntity = new ItemEntity(level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), itemStack);
                    itemEntity.setDefaultPickUpDelay();
                    level.addFreshEntity((Entity)itemEntity);
                }
            }
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }
}

