/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.avaritia.compat.emi.recipe;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.List;
import net.byAqua3.avaritia.compat.emi.AvaritiaEMIPlugin;
import net.byAqua3.avaritia.gui.GuiExtremeCraftingTable;
import net.byAqua3.avaritia.recipe.RecipeExtremeCrafting;
import net.byAqua3.avaritia.recipe.RecipeExtremeShaped;
import net.byAqua3.avaritia.util.RecipeUtils;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import org.jetbrains.annotations.Nullable;

public class EMIRecipeExtremeCrafting
implements EmiRecipe {
    private final RecipeExtremeCrafting recipe;
    private final ResourceLocation id;
    private final List<EmiIngredient> inputs;
    private final List<EmiStack> outputs;

    public EMIRecipeExtremeCrafting(RecipeManager recipeManager, RecipeExtremeCrafting recipe) {
        this.recipe = recipe;
        this.id = RecipeUtils.getRecipeId(recipeManager, recipe);
        this.inputs = recipe.getIngredients().stream().map(ingredient -> EmiIngredient.of((Ingredient)ingredient)).toList();
        this.outputs = List.of(EmiStack.of((ItemStack)recipe.getResultItem((HolderLookup.Provider)RegistryAccess.EMPTY)));
    }

    public RecipeExtremeCrafting getRecipe() {
        return this.recipe;
    }

    public EmiRecipeCategory getCategory() {
        return AvaritiaEMIPlugin.EXTREME_CRAFTING;
    }

    @Nullable
    public ResourceLocation getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return this.inputs;
    }

    public List<EmiStack> getOutputs() {
        return this.outputs;
    }

    public int getDisplayWidth() {
        return 195;
    }

    public int getDisplayHeight() {
        return 168;
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addTexture(GuiExtremeCraftingTable.COMPAT_BACKGROUND_LOCATION, 3, 3, 189, 183, 0, 0, 189, 183, 256, 256);
        List<EmiIngredient> ingredients = this.getInputs();
        ArrayList<SlotWidget> inputSlots = new ArrayList<SlotWidget>();
        for (int y = 0; y < 9; ++y) {
            for (int x = 0; x < 9; ++x) {
                inputSlots.add(new SlotWidget((EmiIngredient)EmiStack.EMPTY, x * 18 + 4, y * 18 + 4).drawBack(false));
            }
        }
        if (this.recipe instanceof RecipeExtremeShaped) {
            RecipeExtremeShaped shapedRecipe = (RecipeExtremeShaped)this.recipe;
            for (int y = 0; y < 9; ++y) {
                for (int x = 0; x < 9; ++x) {
                    int slotIndex = x + y * 9;
                    int inputIndex = x + y * shapedRecipe.getWidth();
                    if (inputIndex >= ingredients.size() || x >= shapedRecipe.getWidth()) continue;
                    SlotWidget originalSlot = (SlotWidget)inputSlots.get(slotIndex);
                    inputSlots.set(slotIndex, new SlotWidget(ingredients.get(inputIndex), originalSlot.getBounds().x(), originalSlot.getBounds().y()).drawBack(false));
                }
            }
        } else {
            widgets.addTexture(EmiTexture.SHAPELESS, widgets.getWidth() - 22, 5);
            for (int i = 0; i < ingredients.size(); ++i) {
                EmiIngredient ingredient = ingredients.get(i);
                SlotWidget originalSlot = (SlotWidget)inputSlots.get(i);
                inputSlots.set(i, new SlotWidget(ingredient, originalSlot.getBounds().x(), originalSlot.getBounds().y()).drawBack(false));
            }
        }
        for (SlotWidget slot : inputSlots) {
            widgets.add((Widget)slot);
        }
        widgets.addSlot((EmiIngredient)this.getOutputs().get(0), 170, 76).drawBack(false).recipeContext((EmiRecipe)this);
    }
}

