/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.avaritia.compat.jei.category;

import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.byAqua3.avaritia.block.BlockNeutronCollector;
import net.byAqua3.avaritia.compat.jei.AvaritiaJEIPlugin;
import net.byAqua3.avaritia.gui.GuiNeutronCollector;
import net.byAqua3.avaritia.loader.AvaritiaBlocks;
import net.byAqua3.avaritia.loader.AvaritiaConfigs;
import net.byAqua3.avaritia.recipe.RecipeCollector;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class CategoryCollectorRecipe
implements IRecipeCategory<RecipeCollector> {
    private final IDrawable background;
    private final IDrawable icon;

    public CategoryCollectorRecipe(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(GuiNeutronCollector.BACKGROUND_LOCATION, 37, 29, 102, 41);
        this.icon = guiHelper.createDrawableItemStack(new ItemStack((ItemLike)AvaritiaBlocks.NEUTRON_COLLECTOR_ITEM.get()));
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public Component getTitle() {
        return BlockNeutronCollector.TITLE;
    }

    public RecipeType<RecipeCollector> getRecipeType() {
        return AvaritiaJEIPlugin.COLLECTOR;
    }

    public void setRecipe(IRecipeLayoutBuilder recipeLayoutBuilder, RecipeCollector recipe, IFocusGroup group) {
        recipeLayoutBuilder.addSlot(RecipeIngredientRole.OUTPUT, 43, 6).addItemStack(recipe.getResultItem((HolderLookup.Provider)RegistryAccess.EMPTY));
    }

    public void draw(RecipeCollector recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Minecraft mc = Minecraft.getInstance();
        Font font = mc.font;
        String time = String.format("%.2f", Float.valueOf((float)((Integer)AvaritiaConfigs.productionTicks.get()).intValue() / 20.0f / 60.0f));
        String text = Component.translatable((String)"avaritia:container.neutron_collector.info", (Object[])new Object[]{time}).getString();
        guiGraphics.drawString(font, text, this.background.getWidth() / 2 - font.width(text) / 2, 31, 0x404040, false);
    }
}

