/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.avaritia.compat.jei.category;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.byAqua3.avaritia.block.BlockNeutroniumCompressor;
import net.byAqua3.avaritia.compat.jei.AvaritiaJEIPlugin;
import net.byAqua3.avaritia.gui.GuiNeutroniumCompressor;
import net.byAqua3.avaritia.loader.AvaritiaBlocks;
import net.byAqua3.avaritia.recipe.RecipeCompressor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class CategoryCompressorRecipe
implements IRecipeCategory<RecipeCompressor> {
    private final IDrawable background;
    private final IDrawable icon;
    private final LoadingCache<Integer, IDrawableAnimated> singularities;

    public CategoryCompressorRecipe(final IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(GuiNeutroniumCompressor.BACKGROUND_LOCATION, 37, 29, 102, 41);
        this.icon = guiHelper.createDrawableItemStack(new ItemStack((ItemLike)AvaritiaBlocks.COMPRESSOR_ITEM.get()));
        this.singularities = CacheBuilder.newBuilder().maximumSize(25L).build((CacheLoader)new CacheLoader<Integer, IDrawableAnimated>(this){

            public IDrawableAnimated load(Integer key) {
                return guiHelper.drawableBuilder(GuiNeutroniumCompressor.BACKGROUND_LOCATION, 176, 16, 16, 16).buildAnimated(Math.max(key / 16, 1), IDrawableAnimated.StartDirection.BOTTOM, false);
            }
        });
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public Component getTitle() {
        return BlockNeutroniumCompressor.TITLE;
    }

    public RecipeType<RecipeCompressor> getRecipeType() {
        return AvaritiaJEIPlugin.COMPRESSOR;
    }

    public void setRecipe(IRecipeLayoutBuilder recipeLayoutBuilder, RecipeCompressor recipe, IFocusGroup group) {
        IRecipeSlotBuilder input = recipeLayoutBuilder.addSlot(RecipeIngredientRole.INPUT, 2, 6);
        recipe.getIngredients().forEach(arg_0 -> ((IRecipeSlotBuilder)input).addIngredients(arg_0));
        recipeLayoutBuilder.addSlot(RecipeIngredientRole.OUTPUT, 80, 6).addItemStack(recipe.getResultItem((HolderLookup.Provider)RegistryAccess.EMPTY));
    }

    public void draw(RecipeCompressor recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        IDrawableAnimated singularity = (IDrawableAnimated)this.singularities.getUnchecked((Object)recipe.getCost());
        singularity.draw(guiGraphics, 53, 6);
        Minecraft mc = Minecraft.getInstance();
        Font font = mc.font;
        String text = Component.translatable((String)"avaritia:container.neutronium_compressor.info", (Object[])new Object[]{recipe.getCost()}).getString();
        guiGraphics.drawString(font, text, this.background.getWidth() / 2 - font.width(text) / 2, 31, 0x404040, false);
    }
}

