/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.avaritia.compat.rei.transfer;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandler;
import me.shedaniel.rei.api.client.registry.transfer.simple.SimpleTransferHandler;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.InputIngredient;
import me.shedaniel.rei.api.common.transfer.info.stack.SlotAccessor;
import net.byAqua3.avaritia.compat.rei.display.DisplayExtremeRecipe;
import net.byAqua3.avaritia.recipe.RecipeExtremeCrafting;
import net.byAqua3.avaritia.recipe.RecipeExtremeShaped;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class TransferHandlerExtremeRecipe {
    public static <C extends AbstractContainerMenu, D extends Display> SimpleTransferHandler create(final Class<? extends C> containerClass, final CategoryIdentifier<D> categoryIdentifier, final SimpleTransferHandler.IntRange inputSlots) {
        return new SimpleTransferHandler(){

            public TransferHandler.ApplicabilityResult checkApplicable(TransferHandler.Context context) {
                if (!containerClass.isInstance(context.getMenu()) || !categoryIdentifier.equals((Object)context.getDisplay().getCategoryIdentifier()) || context.getContainerScreen() == null) {
                    return TransferHandler.ApplicabilityResult.createNotApplicable();
                }
                return TransferHandler.ApplicabilityResult.createApplicable();
            }

            public Iterable<SlotAccessor> getInputSlots(TransferHandler.Context context) {
                if (context.getDisplay() instanceof DisplayExtremeRecipe) {
                    DisplayExtremeRecipe display = (DisplayExtremeRecipe)context.getDisplay();
                    RecipeExtremeCrafting recipe = display.getRecipe();
                    List<EntryIngredient> ingredients = display.getInputEntries();
                    ArrayList<SlotAccessor> inputSlots2 = new ArrayList<SlotAccessor>();
                    if (!display.isShapeless()) {
                        RecipeExtremeShaped shapedRecipe = (RecipeExtremeShaped)recipe;
                        for (int y = 0; y < 9; ++y) {
                            for (int x = 0; x < 9; ++x) {
                                int slotIndex = x + y * 9;
                                int inputIndex = x + y * shapedRecipe.getWidth();
                                if (inputIndex >= ingredients.size() || x >= shapedRecipe.getWidth()) continue;
                                inputSlots2.add(SlotAccessor.fromSlot((Slot)context.getMenu().getSlot(slotIndex + 1)));
                            }
                        }
                        return inputSlots2;
                    }
                }
                return IntStream.range(inputSlots.min(), inputSlots.maxExclusive()).mapToObj(id -> SlotAccessor.fromSlot((Slot)context.getMenu().getSlot(id))).toList();
            }

            public Iterable<SlotAccessor> getInventorySlots(TransferHandler.Context context) {
                Minecraft mc = context.getMinecraft();
                LocalPlayer player = mc.player;
                Inventory inventory = player.getInventory();
                return IntStream.range(0, inventory.items.size()).mapToObj(index -> SlotAccessor.fromPlayerInventory((Player)player, (int)index)).collect(Collectors.toList());
            }

            public void renderMissingInput(TransferHandler.Context context, List<InputIngredient<ItemStack>> inputs, List<InputIngredient<ItemStack>> missing, IntSet missingIndices, GuiGraphics graphics, int mouseX, int mouseY, float partialTicks, List<Widget> widgets, Rectangle rectangle) {
                DisplayExtremeRecipe display = (DisplayExtremeRecipe)context.getDisplay();
                RecipeExtremeCrafting recipe = display.getRecipe();
                List<EntryIngredient> ingredients = display.getInputEntries();
                ArrayList<me.shedaniel.rei.api.client.gui.widgets.Slot> inputSlots2 = new ArrayList<me.shedaniel.rei.api.client.gui.widgets.Slot>();
                for (Widget widget : widgets) {
                    me.shedaniel.rei.api.client.gui.widgets.Slot slot;
                    if (!(widget instanceof me.shedaniel.rei.api.client.gui.widgets.Slot) || (slot = (me.shedaniel.rei.api.client.gui.widgets.Slot)widget).getNoticeMark() != 1) continue;
                    inputSlots2.add(slot);
                }
                if (!display.isShapeless()) {
                    RecipeExtremeShaped shapedRecipe = (RecipeExtremeShaped)recipe;
                    for (int y = 0; y < 9; ++y) {
                        for (int x = 0; x < 9; ++x) {
                            int slotIndex = x + y * 9;
                            int inputIndex = x + y * shapedRecipe.getWidth();
                            if (inputIndex >= ingredients.size() || x >= shapedRecipe.getWidth()) continue;
                            me.shedaniel.rei.api.client.gui.widgets.Slot inputSlot = (me.shedaniel.rei.api.client.gui.widgets.Slot)inputSlots2.get(slotIndex);
                            if (!missingIndices.contains(inputIndex)) continue;
                            graphics.pose().pushPose();
                            graphics.pose().translate(0.0f, 0.0f, 50.0f);
                            Rectangle innerBounds = inputSlot.getInnerBounds();
                            graphics.fill(innerBounds.x, innerBounds.y, innerBounds.getMaxX(), innerBounds.getMaxY(), 0x40FF0000);
                            graphics.pose().popPose();
                        }
                    }
                } else {
                    for (int i = 0; i < inputSlots2.size(); ++i) {
                        me.shedaniel.rei.api.client.gui.widgets.Slot inputSlot = (me.shedaniel.rei.api.client.gui.widgets.Slot)inputSlots2.get(i);
                        if (!missingIndices.contains(i)) continue;
                        graphics.pose().pushPose();
                        graphics.pose().translate(0.0f, 0.0f, 50.0f);
                        Rectangle innerBounds = inputSlot.getInnerBounds();
                        graphics.fill(innerBounds.x, innerBounds.y, innerBounds.getMaxX(), innerBounds.getMaxY(), 0x40FF0000);
                        graphics.pose().popPose();
                    }
                }
            }
        };
    }
}

