/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.avaritia.entity;

import java.util.ArrayList;
import java.util.List;
import net.byAqua3.avaritia.entity.EntityEndestPearl;
import net.byAqua3.avaritia.loader.AvaritiaEntities;
import net.byAqua3.avaritia.loader.AvaritiaSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EntityGapingVoid
extends Entity {
    private static final EntityDataAccessor<Integer> AGE = SynchedEntityData.defineId(EntityGapingVoid.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final int MAX_LIFETIME = 186;
    public static final double COLLAPSE = 0.95;
    private static final int SUCK_RANGE = 20;
    private Player player;

    public EntityGapingVoid(EntityType<?> entityType, Level level) {
        super(entityType, level);
        this.noCulling = true;
    }

    public EntityGapingVoid(Level level) {
        this((EntityType)AvaritiaEntities.GAPING_VOID.get(), level);
    }

    public int getAge() {
        return (Integer)this.entityData.get(AGE);
    }

    public void setAge(int age) {
        this.entityData.set(AGE, (Object)age);
    }

    public Player getPlayer() {
        return this.player;
    }

    public void setPlayer(Player player) {
        this.player = player;
    }

    public void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(AGE, (Object)0);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        this.setAge(tag.getInt("age"));
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        tag.putInt("age", this.getAge());
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        double d0 = 1.0;
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return distance < (d0 *= 64.0 * Entity.getViewScale()) * d0;
    }

    private static double ease(double in) {
        double t = in - 1.0;
        return Math.sqrt(1.0 - t * t);
    }

    public static double getVoidScale(double age) {
        double life = age / 186.0;
        double curve = life < 0.95 ? 0.005 + EntityGapingVoid.ease(1.0 - (0.95 - life) / 0.95) * 0.995 : EntityGapingVoid.ease(1.0 - (life - 0.95) / 0.050000000000000044);
        return 10.0 * curve;
    }

    private boolean shouldSuck(Entity entity) {
        if (entity instanceof EntityEndestPearl) {
            return false;
        }
        if (entity instanceof EntityGapingVoid) {
            return false;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return !player.isCreative();
        }
        return true;
    }

    private boolean shouldAttack(Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return false;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return !player.isCreative();
        }
        return true;
    }

    public void tick() {
        super.tick();
        int age = this.getAge();
        if (age == 0) {
            this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), (SoundEvent)AvaritiaSounds.GAPING_VOID.get(), SoundSource.HOSTILE, 8.0f, 1.0f, true);
        }
        this.setAge(age + 1);
        Vec3 pos = this.position();
        double voidScale = EntityGapingVoid.getVoidScale(age);
        for (int i = 0; i < 50; ++i) {
            this.level().addParticle((ParticleOptions)ParticleTypes.PORTAL, this.getX(), this.getY(), this.getZ(), this.random.nextGaussian() * 3.0, this.random.nextGaussian() * 3.0, this.random.nextGaussian() * 3.0);
        }
        double radius = voidScale * 0.5;
        AABB aabb = AABB.encapsulatingFullBlocks((BlockPos)this.blockPosition().offset(new Vec3i(-20, -20, -20)), (BlockPos)this.blockPosition().offset(new Vec3i(20, 20, 20)));
        List entities = this.level().getEntitiesOfClass(Entity.class, aabb, this::shouldSuck);
        for (Entity entity : entities) {
            if (entity == this) continue;
            double posX = pos.x - entity.getX();
            double posY = pos.y - entity.getY();
            double posZ = pos.z - entity.getZ();
            double len = Math.sqrt(posX * posX + posY * posY + posZ * posZ);
            double lenn = len / 20.0;
            if (!(len <= 20.0)) continue;
            double strength = (1.0 - lenn) * (1.0 - lenn);
            double power = 0.075 * radius;
            if (entity instanceof WitherBoss) {
                power *= 100.0;
            }
            Vec3 motion = entity.getDeltaMovement();
            double motionX = motion.x() + posX / len * strength * power;
            double motionY = motion.y() + posY / len * strength * power;
            double motionZ = motion.z() + posZ / len * strength * power;
            entity.setDeltaMovement(motionX, motionY, motionZ);
        }
        int attackRange = (int)(radius * 0.95);
        aabb = AABB.encapsulatingFullBlocks((BlockPos)this.blockPosition().offset(new Vec3i(-attackRange, -attackRange, -attackRange)), (BlockPos)this.blockPosition().offset(new Vec3i(attackRange, attackRange, attackRange)));
        List entitiesToAttack = this.level().getEntitiesOfClass(LivingEntity.class, aabb, this::shouldAttack);
        for (Entity toAttack : entitiesToAttack) {
            double posZ;
            double posY;
            double posX;
            double len;
            if (toAttack == this || !((len = Math.sqrt((posX = pos.x - toAttack.getX()) * posX + (posY = pos.y - toAttack.getY()) * posY + (posZ = pos.z - toAttack.getZ()) * posZ)) <= (double)attackRange)) continue;
            if (toAttack instanceof EnderMan || toAttack instanceof EnderDragon) {
                toAttack.hurt(this.damageSources().playerAttack(this.player), 10.0f);
                continue;
            }
            if (toAttack instanceof WitherBoss) {
                toAttack.hurt(this.damageSources().fellOutOfWorld(), 20.0f);
                continue;
            }
            toAttack.hurt(this.damageSources().fellOutOfWorld(), 10.0f);
        }
        attackRange = (int)((double)attackRange + 2.0);
        if (age % 10 == 0) {
            Vec3 pos1 = pos;
            int blockRange = Math.round(attackRange);
            for (int y = -blockRange; y <= blockRange; ++y) {
                for (int z = -blockRange; z <= blockRange; ++z) {
                    for (int x = -blockRange; x <= blockRange; ++x) {
                        float resist;
                        Vec3 pos2 = new Vec3((double)x, (double)y, (double)z);
                        Vec3 rPos = pos1.add(pos2);
                        BlockPos blockPos = new BlockPos(Mth.floor((double)rPos.x), Mth.floor((double)rPos.y), Mth.floor((double)rPos.z));
                        BlockState blockState = this.level().getBlockState(blockPos);
                        Block block = blockState.getBlock();
                        double dist = Math.sqrt(pos2.x * pos2.x + pos2.y * pos2.y + pos2.z * pos2.z);
                        if (!(dist <= (double)attackRange) || blockState.isAir() || !((resist = block.getExplosionResistance()) <= 10.0f)) continue;
                        if (!(block instanceof BaseFireBlock)) {
                            this.level().levelEvent(2001, blockPos, Block.getId((BlockState)blockState));
                        }
                        this.level().setBlockAndUpdate(blockPos, Blocks.AIR.defaultBlockState());
                        this.level().gameEvent((Holder)GameEvent.BLOCK_DESTROY, blockPos, GameEvent.Context.of((Entity)this.player, (BlockState)blockState));
                        if (this.level().isClientSide()) continue;
                        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
                        List blockDrops = Block.getDrops((BlockState)blockState, (ServerLevel)((ServerLevel)this.level()), (BlockPos)blockPos, null);
                        if (!blockDrops.isEmpty()) {
                            drops.addAll(blockDrops);
                        } else {
                            ResourceLocation blockKey = BuiltInRegistries.BLOCK.getKey((Object)block);
                            Item blockItem = (Item)BuiltInRegistries.ITEM.get(blockKey);
                            drops.add(new ItemStack((ItemLike)blockItem));
                        }
                        if (drops.isEmpty()) continue;
                        for (ItemStack itemStack : drops) {
                            ItemEntity itemEntity = new ItemEntity(this.level(), (double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ(), itemStack);
                            itemEntity.setDefaultPickUpDelay();
                            this.level().addFreshEntity((Entity)itemEntity);
                        }
                    }
                }
            }
        }
        if (age >= 186) {
            this.level().explode((Entity)this, this.getX(), this.getY(), this.getZ(), 6.0f, false, Level.ExplosionInteraction.BLOCK);
            this.setAge(0);
            this.remove(Entity.RemovalReason.KILLED);
        }
    }
}

