/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.avaritia.geometry;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import java.util.Random;
import net.byAqua3.avaritia.geometry.BakedModelRenderer;
import net.byAqua3.avaritia.item.ItemSingularity;
import net.byAqua3.avaritia.util.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class BakedModelHalo
extends BakedModelRenderer {
    private final int type;
    private final float alpha;
    private final boolean pulse;

    public BakedModelHalo(BakedModel bakedModel, int type, float alpha, boolean pulse) {
        super(bakedModel);
        this.type = type;
        this.alpha = alpha;
        this.pulse = pulse;
    }

    @Override
    public void render(ItemStack stack, ItemDisplayContext context, boolean leftHand, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight, int packedOverlay, BakedModel model) {
        Minecraft mc = Minecraft.getInstance();
        ItemRenderer itemRenderer = mc.getItemRenderer();
        TextureAtlas textureAtlas = mc.getModelManager().getAtlas(InventoryMenu.BLOCK_ATLAS);
        for (BakedModel bakedModel : model.getRenderPasses(stack, true)) {
            for (RenderType renderType : bakedModel.getRenderTypes(stack, true)) {
                int type = this.type;
                float alpha = this.alpha;
                boolean pulse = this.pulse;
                VertexConsumer vertexConsumer = multiBufferSource.getBuffer(renderType);
                if (context == ItemDisplayContext.GUI) {
                    List<BakedQuad> quads;
                    PoseStack.Pose poseStack$pose;
                    if (type == 0) {
                        poseStack.pushPose();
                        poseStack$pose = poseStack.last();
                        RenderSystem.enableBlend();
                        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                        RenderSystem.disableDepthTest();
                        poseStack.scale(2.25f, 2.25f, 1.0f);
                        poseStack.translate(-0.295f, -0.265f, 0.0f);
                        quads = RenderUtils.bakeItem(textureAtlas.getSprite(ResourceLocation.tryBuild((String)"avaritia", (String)"item/halo")));
                        for (BakedQuad quad : quads) {
                            vertexConsumer.putBulkData(poseStack$pose, quad, 0.0f, 0.0f, 0.0f, alpha, packedLight, packedOverlay, true);
                        }
                        poseStack.popPose();
                    } else if (type == 1) {
                        poseStack.pushPose();
                        PoseStack.Pose poseStack$pose2 = poseStack.last();
                        poseStack.scale(2.0f, 2.0f, 1.0f);
                        poseStack.translate(-0.25f, -0.255f, 0.0f);
                        List<BakedQuad> quads2 = RenderUtils.bakeItem(textureAtlas.getSprite(ResourceLocation.tryBuild((String)"avaritia", (String)"item/halo_noise")));
                        for (BakedQuad quad : quads2) {
                            vertexConsumer.putBulkData(poseStack$pose2, quad, 1.0f, 1.0f, 1.0f, alpha, packedLight, packedOverlay, true);
                        }
                        poseStack.popPose();
                    }
                    if (type == 2) {
                        poseStack.pushPose();
                        poseStack$pose = poseStack.last();
                        poseStack.scale(1.5f, 1.5f, 1.0f);
                        poseStack.translate(-0.17f, -0.155f, 0.0f);
                        quads = RenderUtils.bakeItem(textureAtlas.getSprite(ResourceLocation.tryBuild((String)"avaritia", (String)"item/halo")));
                        for (BakedQuad quad : quads) {
                            vertexConsumer.putBulkData(poseStack$pose, quad, 0.0f, 0.0f, 0.0f, alpha, packedLight, packedOverlay, true);
                        }
                        poseStack.popPose();
                    }
                    if (type == 0 || pulse) {
                        float scale = new Random().nextFloat() * 0.1f + 0.95f;
                        double translate = (1.0 - (double)scale) / 2.0;
                        poseStack.scale(scale, scale, 1.0001f);
                        poseStack.translate(translate, translate, 0.0);
                    }
                }
                if (stack.getItem() instanceof ItemSingularity) {
                    RenderUtils.renderSingularity(stack, poseStack, vertexConsumer, packedLight, packedOverlay);
                    continue;
                }
                itemRenderer.renderModelLists(bakedModel, stack, packedLight, packedOverlay, poseStack, vertexConsumer);
            }
        }
    }
}

