/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.avaritia.gui;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.datafixers.util.Pair;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Set;
import net.byAqua3.avaritia.inventory.MenuInfinityChest;
import net.byAqua3.avaritia.inventory.slot.SlotInfinity;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class GuiInfinityChest
extends AbstractContainerScreen<MenuInfinityChest> {
    public static final ResourceLocation BACKGROUND_LOCATION = ResourceLocation.tryBuild((String)"avaritia", (String)"textures/gui/infinity_chest.png");

    public GuiInfinityChest(MenuInfinityChest menu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)menu, inventory, title);
        this.imageWidth = 462;
        this.imageHeight = 330;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        guiGraphics.blit(BACKGROUND_LOCATION, this.getGuiLeft(), this.getGuiTop(), 0.0f, 0.0f, this.imageWidth, this.imageHeight, 512, 512);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, 0x404040, false);
        guiGraphics.drawString(this.font, this.playerInventoryTitle, 152, 236, 0x404040, false);
    }

    protected void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (((MenuInfinityChest)this.menu).getCarried().isEmpty() && this.hoveredSlot != null && this.hoveredSlot.hasItem()) {
            ItemStack itemStack = this.hoveredSlot.getItem();
            List components = this.getTooltipFromContainerItem(itemStack);
            if (this.hoveredSlot instanceof SlotInfinity) {
                components.add(Component.translatable((String)"avaritia:container.infinity_chest.info", (Object[])new Object[]{itemStack.getCount(), ((MenuInfinityChest)this.menu).getSlotMaxStack(this.hoveredSlot)}));
            }
            guiGraphics.renderTooltip(this.font, components, itemStack.getTooltipImage(), itemStack, mouseX, mouseY);
        }
    }

    protected void renderSlot(GuiGraphics guiGraphics, Slot slot) {
        Pair pair;
        int i = slot.x;
        int j = slot.y;
        ItemStack itemStack = slot.getItem();
        boolean flag = false;
        boolean flag1 = slot == this.clickedSlot && !this.draggingItem.isEmpty() && !this.isSplittingStack;
        ItemStack itemStack1 = ((MenuInfinityChest)this.menu).getCarried();
        if (slot == this.clickedSlot && !this.draggingItem.isEmpty() && this.isSplittingStack && !itemStack.isEmpty()) {
            itemStack = itemStack.copyWithCount(itemStack.getCount() / 2);
        } else if (this.isQuickCrafting && this.quickCraftSlots.contains(slot) && !itemStack1.isEmpty()) {
            if (this.quickCraftSlots.size() == 1) {
                return;
            }
            if (MenuInfinityChest.canItemQuickReplace((Container)((MenuInfinityChest)this.menu).getTile().chest, slot, itemStack1, true, ((MenuInfinityChest)this.menu).getSlotMaxStack(slot)) && ((MenuInfinityChest)this.menu).canDragTo(slot)) {
                flag = true;
                int k = Math.min(((MenuInfinityChest)this.menu).getTile().chest.getMaxStackSize(itemStack1), ((MenuInfinityChest)this.menu).getSlotMaxStack(slot));
                int l = slot.getItem().isEmpty() ? 0 : slot.getItem().getCount();
                int i1 = MenuInfinityChest.getQuickCraftPlaceCount((Set)this.quickCraftSlots, (int)this.quickCraftingType, (ItemStack)itemStack1) + l;
                if (i1 > k) {
                    i1 = k;
                }
                itemStack = itemStack1.copyWithCount(i1);
            } else {
                this.quickCraftSlots.remove(slot);
                this.recalculateQuickCraftRemaining();
            }
        }
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.0f, 0.0f, 100.0f);
        if (itemStack.isEmpty() && slot.isActive() && (pair = slot.getNoItemIcon()) != null) {
            TextureAtlasSprite textureatlassprite = (TextureAtlasSprite)this.minecraft.getTextureAtlas((ResourceLocation)pair.getFirst()).apply((ResourceLocation)pair.getSecond());
            guiGraphics.blit(i, j, 0, 16, 16, textureatlassprite);
            flag1 = true;
        }
        if (!flag1) {
            if (flag) {
                guiGraphics.fill(i, j, i + 16, j + 16, -2130706433);
            }
            int j1 = slot.x + slot.y * this.imageWidth;
            if (slot.isFake()) {
                guiGraphics.renderFakeItem(itemStack, i, j, j1);
            } else {
                guiGraphics.renderItem(itemStack, i, j, j1);
            }
            String text = null;
            int count = itemStack.getCount();
            if (count >= 1000) {
                text = new DecimalFormat("#").format(count / 1000) + "K";
            }
            if (count >= 10000) {
                text = new DecimalFormat("#").format(count / 10000) + "W";
            }
            if (count >= 1000000) {
                text = new DecimalFormat("#").format(count / 1000000) + "M";
            }
            if (count >= 1000000000) {
                text = new DecimalFormat("#").format(count / 1000000000) + "G";
            }
            guiGraphics.renderItemDecorations(this.font, itemStack, i, j, text);
        }
        guiGraphics.pose().popPose();
    }

    public void recalculateQuickCraftRemaining() {
        ItemStack itemStack = ((MenuInfinityChest)this.menu).getCarried();
        if (!itemStack.isEmpty() && this.isQuickCrafting) {
            if (this.quickCraftingType == 2) {
                this.quickCraftingRemainder = itemStack.getMaxStackSize();
            } else {
                this.quickCraftingRemainder = itemStack.getCount();
                for (Slot slot : this.quickCraftSlots) {
                    ItemStack itemStack1 = slot.getItem();
                    int i = itemStack1.isEmpty() ? 0 : itemStack1.getCount();
                    int j = Math.min(((MenuInfinityChest)this.menu).getTile().chest.getMaxStackSize(itemStack), ((MenuInfinityChest)this.menu).getSlotMaxStack(slot));
                    int k = Math.min(MenuInfinityChest.getQuickCraftPlaceCount((Set)this.quickCraftSlots, (int)this.quickCraftingType, (ItemStack)itemStack) + i, j);
                    this.quickCraftingRemainder -= k - i;
                }
            }
        }
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        Slot slot = this.findSlot(mouseX, mouseY);
        ItemStack itemStack = ((MenuInfinityChest)this.menu).getCarried();
        if (this.clickedSlot != null && ((Boolean)this.minecraft.options.touchscreen().get()).booleanValue()) {
            if (button == 0 || button == 1) {
                if (this.draggingItem.isEmpty()) {
                    if (slot != this.clickedSlot && !this.clickedSlot.getItem().isEmpty()) {
                        this.draggingItem = this.clickedSlot.getItem().copy();
                    }
                } else if (this.draggingItem.getCount() > 1 && slot != null && MenuInfinityChest.canItemQuickReplace((Container)((MenuInfinityChest)this.menu).getTile().chest, slot, this.draggingItem, false, ((MenuInfinityChest)this.menu).getSlotMaxStack(slot))) {
                    long i = Util.getMillis();
                    if (this.quickdropSlot == slot) {
                        if (i - this.quickdropTime > 500L) {
                            this.slotClicked(this.clickedSlot, this.clickedSlot.index, 0, ClickType.PICKUP);
                            this.slotClicked(slot, slot.index, 1, ClickType.PICKUP);
                            this.slotClicked(this.clickedSlot, this.clickedSlot.index, 0, ClickType.PICKUP);
                            this.quickdropTime = i + 750L;
                            this.draggingItem.shrink(1);
                        }
                    } else {
                        this.quickdropSlot = slot;
                        this.quickdropTime = i;
                    }
                }
            }
        } else if (this.isQuickCrafting && slot != null && !itemStack.isEmpty() && (itemStack.getCount() > this.quickCraftSlots.size() || this.quickCraftingType == 2) && MenuInfinityChest.canItemQuickReplace((Container)((MenuInfinityChest)this.menu).getTile().chest, slot, itemStack, true, ((MenuInfinityChest)this.menu).getSlotMaxStack(slot)) && slot.mayPlace(itemStack) && ((MenuInfinityChest)this.menu).canDragTo(slot)) {
            this.quickCraftSlots.add(slot);
            this.recalculateQuickCraftRemaining();
        }
        return true;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (button == 0 && this.isDragging()) {
            this.setDragging(false);
            if (this.getFocused() != null) {
                return this.getFocused().mouseReleased(mouseX, mouseY, button);
            }
        }
        this.getChildAt(mouseX, mouseY).filter(listener -> listener.mouseReleased(mouseX, mouseY, button));
        Slot slot = this.findSlot(mouseX, mouseY);
        int i = this.leftPos;
        int j = this.topPos;
        boolean flag = this.hasClickedOutside(mouseX, mouseY, i, j, button);
        if (slot != null) {
            flag = false;
        }
        InputConstants.Key mouseKey = InputConstants.Type.MOUSE.getOrCreate(button);
        int k = -1;
        if (slot != null) {
            k = slot.index;
        }
        if (flag) {
            k = -999;
        }
        if (this.doubleclick && slot != null && button == 0 && ((MenuInfinityChest)this.menu).canTakeItemForPickAll(ItemStack.EMPTY, slot)) {
            if (GuiInfinityChest.hasShiftDown()) {
                if (!this.lastQuickMoved.isEmpty()) {
                    for (Slot slot2 : ((MenuInfinityChest)this.menu).slots) {
                        if (slot2 == null || !slot2.mayPickup((Player)this.minecraft.player) || !slot2.hasItem() || !slot2.isSameInventory(slot) || !MenuInfinityChest.canItemQuickReplace((Container)((MenuInfinityChest)this.menu).getTile().chest, slot2, this.lastQuickMoved, true, ((MenuInfinityChest)this.menu).getSlotMaxStack(slot2))) continue;
                        this.slotClicked(slot2, slot2.index, button, ClickType.QUICK_MOVE);
                    }
                }
            } else {
                this.slotClicked(slot, k, button, ClickType.PICKUP_ALL);
            }
            this.doubleclick = false;
            this.lastClickTime = 0L;
        } else {
            if (this.isQuickCrafting && this.quickCraftingButton != button) {
                this.isQuickCrafting = false;
                this.quickCraftSlots.clear();
                this.skipNextRelease = true;
                return true;
            }
            if (this.skipNextRelease) {
                this.skipNextRelease = false;
                return true;
            }
            if (this.clickedSlot != null && ((Boolean)this.minecraft.options.touchscreen().get()).booleanValue()) {
                if (button == 0 || button == 1) {
                    if (this.draggingItem.isEmpty() && slot != this.clickedSlot) {
                        this.draggingItem = this.clickedSlot.getItem();
                    }
                    boolean flag2 = MenuInfinityChest.canItemQuickReplace((Container)((MenuInfinityChest)this.menu).getTile().chest, slot, this.draggingItem, false, ((MenuInfinityChest)this.menu).getSlotMaxStack(slot));
                    if (k != -1 && !this.draggingItem.isEmpty() && flag2) {
                        this.slotClicked(this.clickedSlot, this.clickedSlot.index, button, ClickType.PICKUP);
                        this.slotClicked(slot, k, 0, ClickType.PICKUP);
                        if (((MenuInfinityChest)this.menu).getCarried().isEmpty()) {
                            this.snapbackItem = ItemStack.EMPTY;
                        } else {
                            this.slotClicked(this.clickedSlot, this.clickedSlot.index, button, ClickType.PICKUP);
                            this.snapbackStartX = Mth.floor((double)(mouseX - (double)i));
                            this.snapbackStartY = Mth.floor((double)(mouseY - (double)j));
                            this.snapbackEnd = this.clickedSlot;
                            this.snapbackItem = this.draggingItem;
                            this.snapbackTime = Util.getMillis();
                        }
                    } else if (!this.draggingItem.isEmpty()) {
                        this.snapbackStartX = Mth.floor((double)(mouseX - (double)i));
                        this.snapbackStartY = Mth.floor((double)(mouseY - (double)j));
                        this.snapbackEnd = this.clickedSlot;
                        this.snapbackItem = this.draggingItem;
                        this.snapbackTime = Util.getMillis();
                    }
                    this.clearDraggingState();
                }
            } else if (this.isQuickCrafting && !this.quickCraftSlots.isEmpty()) {
                this.slotClicked(null, -999, AbstractContainerMenu.getQuickcraftMask((int)0, (int)this.quickCraftingType), ClickType.QUICK_CRAFT);
                for (Slot slot1 : this.quickCraftSlots) {
                    this.slotClicked(slot1, slot1.index, AbstractContainerMenu.getQuickcraftMask((int)1, (int)this.quickCraftingType), ClickType.QUICK_CRAFT);
                }
                this.slotClicked(null, -999, AbstractContainerMenu.getQuickcraftMask((int)2, (int)this.quickCraftingType), ClickType.QUICK_CRAFT);
            } else if (!((MenuInfinityChest)this.menu).getCarried().isEmpty()) {
                if (this.minecraft.options.keyPickItem.isActiveAndMatches(mouseKey)) {
                    this.slotClicked(slot, k, button, ClickType.CLONE);
                } else {
                    boolean flag1;
                    boolean bl = flag1 = k != -999 && (InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)340) || InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)344));
                    if (flag1) {
                        this.lastQuickMoved = slot != null && slot.hasItem() ? slot.getItem().copy() : ItemStack.EMPTY;
                    }
                    this.slotClicked(slot, k, button, flag1 ? ClickType.QUICK_MOVE : ClickType.PICKUP);
                }
            }
        }
        if (((MenuInfinityChest)this.menu).getCarried().isEmpty()) {
            this.lastClickTime = 0L;
        }
        this.isQuickCrafting = false;
        return true;
    }
}

