/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.avaritia.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.byAqua3.avaritia.item.ItemInfinitySingularity;
import net.byAqua3.avaritia.item.ItemJsonSingularity;
import net.byAqua3.avaritia.item.ItemSingularity;
import net.byAqua3.avaritia.loader.AvaritiaDataComponents;
import net.byAqua3.avaritia.loader.AvaritiaItems;
import net.byAqua3.avaritia.loader.AvaritiaRecipes;
import net.byAqua3.avaritia.loader.AvaritiaSingularities;
import net.byAqua3.avaritia.recipe.RecipeExtremeCrafting;
import net.byAqua3.avaritia.singularity.Singularity;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.crafting.DataComponentIngredient;
import net.neoforged.neoforge.common.util.RecipeMatcher;

public class RecipeExtremeShapeless
implements RecipeExtremeCrafting {
    public final String group;
    public final ItemStack result;
    public final NonNullList<Ingredient> ingredients;
    public final boolean hasSingularities;
    private final boolean isSimple;

    public RecipeExtremeShapeless(String group, ItemStack result, List<Ingredient> ingredients, boolean hasSingularities) {
        this.group = group;
        this.result = result;
        this.ingredients = NonNullList.copyOf(ingredients);
        this.hasSingularities = hasSingularities;
        this.isSimple = hasSingularities ? false : this.getIngredients().stream().allMatch(Ingredient::isSimple);
    }

    public boolean matches(CraftingInput container, Level level) {
        StackedContents stackedContents = new StackedContents();
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        int i = 0;
        for (int j = 0; j < container.size(); ++j) {
            ItemStack itemStack = container.getItem(j);
            if (itemStack.isEmpty()) continue;
            ++i;
            if (this.isSimple) {
                stackedContents.accountStack(itemStack, 1);
                continue;
            }
            inputs.add(itemStack);
        }
        return i == this.getIngredients().size() && (this.isSimple ? stackedContents.canCraft((Recipe)this, null) : RecipeMatcher.findMatches(inputs, this.getIngredients()) != null);
    }

    public boolean showNotification() {
        return false;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= this.getIngredients().size();
    }

    public ItemStack assemble(CraftingInput container, HolderLookup.Provider registryAccess) {
        return this.result.copy();
    }

    public String getGroup() {
        return this.group;
    }

    public ItemStack getResultItem(HolderLookup.Provider registryAccess) {
        return this.result;
    }

    public NonNullList<Ingredient> getIngredients() {
        if (this.hasSingularities) {
            ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>();
            ingredients.addAll((Collection<Ingredient>)this.ingredients);
            for (Item item : BuiltInRegistries.ITEM) {
                if (!(item instanceof ItemSingularity) || item instanceof ItemJsonSingularity || item instanceof ItemInfinitySingularity) continue;
                ingredients.add(Ingredient.of((ItemLike[])new ItemLike[]{item}));
            }
            for (Singularity singularity : AvaritiaSingularities.getInstance().getSingularities()) {
                ItemStack itemStack = new ItemStack((ItemLike)AvaritiaItems.JSON_SINGULARITY.get());
                itemStack.set((DataComponentType)AvaritiaDataComponents.SINGULARITY_ID.get(), (Object)singularity.getId());
                ingredients.add(DataComponentIngredient.of((boolean)true, (ItemStack)itemStack));
            }
            return NonNullList.copyOf(ingredients);
        }
        return this.ingredients;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)AvaritiaRecipes.EXTREME_SHAPELESS_RECIPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<RecipeExtremeShapeless> {
        public static final MapCodec<RecipeExtremeShapeless> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(recipe -> recipe.group), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(recipe -> recipe.result), (App)Ingredient.CODEC_NONEMPTY.listOf().fieldOf("ingredients").forGetter(recipe -> recipe.ingredients), (App)Codec.BOOL.optionalFieldOf("singularities", (Object)false).forGetter(recipe -> recipe.hasSingularities)).apply((Applicative)instance, RecipeExtremeShapeless::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, RecipeExtremeShapeless> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<RecipeExtremeShapeless> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, RecipeExtremeShapeless> streamCodec() {
            return STREAM_CODEC;
        }

        private static RecipeExtremeShapeless fromNetwork(RegistryFriendlyByteBuf friendlyByteBuf) {
            String group = friendlyByteBuf.readUtf();
            int i = friendlyByteBuf.readVarInt();
            NonNullList ingredients = NonNullList.withSize((int)i, (Object)Ingredient.EMPTY);
            for (int j = 0; j < ingredients.size(); ++j) {
                ingredients.set(j, (Object)((Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)friendlyByteBuf)));
            }
            ItemStack itemStack = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)friendlyByteBuf);
            boolean hasSingularities = friendlyByteBuf.readBoolean();
            return new RecipeExtremeShapeless(group, itemStack, (List<Ingredient>)ingredients, hasSingularities);
        }

        private static void toNetwork(RegistryFriendlyByteBuf friendlyByteBuf, RecipeExtremeShapeless recipe) {
            friendlyByteBuf.writeUtf(recipe.group);
            friendlyByteBuf.writeVarInt(recipe.ingredients.size());
            for (Ingredient ingredient : recipe.ingredients) {
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)friendlyByteBuf, (Object)ingredient);
            }
            ItemStack.STREAM_CODEC.encode((Object)friendlyByteBuf, (Object)recipe.result);
            friendlyByteBuf.writeBoolean(recipe.hasSingularities);
        }
    }
}

