/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.avaritia.tile;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.byAqua3.avaritia.Avaritia;
import net.byAqua3.avaritia.component.ClusterContainerContents;
import net.byAqua3.avaritia.inventory.MenuInfinityChest;
import net.byAqua3.avaritia.loader.AvaritiaBlocks;
import net.byAqua3.avaritia.loader.AvaritiaConfigs;
import net.byAqua3.avaritia.loader.AvaritiaDataComponents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestLidController;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.util.DataComponentUtil;

public class TileInfinityChest
extends BlockEntity
implements LidBlockEntity {
    private final ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        protected void onOpen(Level level, BlockPos pos, BlockState state) {
            level.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.CHEST_OPEN, SoundSource.BLOCKS, 0.5f, level.random.nextFloat() * 0.1f + 0.9f);
        }

        protected void onClose(Level level, BlockPos pos, BlockState state) {
            level.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.CHEST_CLOSE, SoundSource.BLOCKS, 0.5f, level.random.nextFloat() * 0.1f + 0.9f);
        }

        protected void openerCountChanged(Level level, BlockPos pos, BlockState state, int count, int openCount) {
            TileInfinityChest.this.signalOpenCount(level, pos, state, count, openCount);
        }

        protected boolean isOwnContainer(Player player) {
            if (!(player.containerMenu instanceof MenuInfinityChest)) {
                return false;
            }
            MenuInfinityChest menu = (MenuInfinityChest)player.containerMenu;
            TileInfinityChest tile = menu.getTile();
            return tile == TileInfinityChest.this;
        }
    };
    private final ChestLidController chestLidController = new ChestLidController();
    public final SimpleContainer chest = new SimpleContainer(300){

        public void setChanged() {
            TileInfinityChest.this.setChanged();
        }

        public int getMaxStackSize() {
            return Integer.MAX_VALUE;
        }

        public int getMaxStackSize(ItemStack stack) {
            int maxStackSize = Math.max(stack.getCount(), (Integer)AvaritiaConfigs.maxStackSize.get());
            return Math.min(this.getMaxStackSize(), maxStackSize);
        }

        public void fillStackedContents(StackedContents stackedContents) {
            for (ItemStack itemStack : this.getItems()) {
                stackedContents.accountStack(itemStack, Integer.MAX_VALUE);
            }
        }

        public void startOpen(Player player) {
            if (!TileInfinityChest.this.remove && !player.isSpectator()) {
                TileInfinityChest.this.openersCounter.incrementOpeners(player, TileInfinityChest.this.getLevel(), TileInfinityChest.this.getBlockPos(), TileInfinityChest.this.getBlockState());
            }
        }

        public void stopOpen(Player player) {
            if (!TileInfinityChest.this.remove && !player.isSpectator()) {
                TileInfinityChest.this.openersCounter.decrementOpeners(player, TileInfinityChest.this.getLevel(), TileInfinityChest.this.getBlockPos(), TileInfinityChest.this.getBlockState());
            }
        }
    };
    public static final Codec<ItemStack> CODEC = Codec.lazyInitialized(() -> RecordCodecBuilder.create(instance -> instance.group((App)ItemStack.ITEM_NON_AIR_CODEC.fieldOf("id").forGetter(ItemStack::getItemHolder), (App)ExtraCodecs.intRange((int)1, (int)Integer.MAX_VALUE).fieldOf("count").orElse((Object)1).forGetter(ItemStack::getCount), (App)DataComponentPatch.CODEC.optionalFieldOf("components", (Object)DataComponentPatch.EMPTY).forGetter(itemStack -> itemStack.getComponentsPatch())).apply((Applicative)instance, ItemStack::new)));

    public TileInfinityChest(BlockPos pos, BlockState state) {
        super((BlockEntityType)AvaritiaBlocks.INFINITY_CHEST_TILE.get(), pos, state);
    }

    public static void lidAnimateTick(Level level, BlockPos pos, BlockState state, TileInfinityChest blockEntity) {
        blockEntity.chestLidController.tickLid();
    }

    protected void signalOpenCount(Level level, BlockPos pos, BlockState state, int eventId, int eventParam) {
        Block block = state.getBlock();
        level.blockEvent(pos, block, 1, eventParam);
    }

    public void recheckOpen() {
        if (!this.remove) {
            this.openersCounter.recheckOpeners(this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    public float getOpenNess(float partialTicks) {
        return this.chestLidController.getOpenness(partialTicks);
    }

    public boolean triggerEvent(int id, int type) {
        if (id == 1) {
            this.chestLidController.shouldBeOpen(type > 0);
            return true;
        }
        return super.triggerEvent(id, type);
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        if (tag.contains("Items", 9)) {
            ListTag tagList = tag.getList("Items", 10);
            for (int i = 0; i < tagList.size(); ++i) {
                CompoundTag compoundTag = tagList.getCompound(i);
                int j = compoundTag.getInt("Slot");
                if (j < 0 || j >= this.chest.getItems().size()) continue;
                ItemStack itemStack = CODEC.parse((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)compoundTag).resultOrPartial(error -> Avaritia.LOGGER.error("Tried to load invalid item: '{}'", error)).orElse(ItemStack.EMPTY);
                this.chest.getItems().set(j, (Object)itemStack);
            }
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        ListTag tagList = new ListTag();
        for (int i = 0; i < this.chest.getItems().size(); ++i) {
            ItemStack itemStack = (ItemStack)this.chest.getItems().get(i);
            if (itemStack.isEmpty()) continue;
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.putInt("Slot", i);
            tagList.add((Object)DataComponentUtil.wrapEncodingExceptions((DataComponentHolder)itemStack, CODEC, (HolderLookup.Provider)provider, (Tag)compoundTag));
        }
        if (!tagList.isEmpty()) {
            tag.put("Items", (Tag)tagList);
        }
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput componentInput) {
        super.applyImplicitComponents(componentInput);
        NonNullList itemStacks = NonNullList.withSize((int)300, (Object)ItemStack.EMPTY);
        ((ClusterContainerContents)componentInput.getOrDefault(AvaritiaDataComponents.CLUSTER_CONTAINER, (Object)ClusterContainerContents.EMPTY)).copyInto((NonNullList<ItemStack>)itemStacks);
        if (!itemStacks.isEmpty()) {
            for (int i = 0; i < itemStacks.size(); ++i) {
                this.chest.getItems().set(i, (Object)((ItemStack)itemStacks.get(i)));
            }
        }
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        NonNullList itemStacks = this.chest.getItems();
        builder.set(AvaritiaDataComponents.CLUSTER_CONTAINER, (Object)ClusterContainerContents.fromItems((List<ItemStack>)itemStacks));
    }
}

