/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.render;

import codechicken.lib.gui.modular.lib.GuiRender;
import codechicken.lib.gui.modular.sprite.Material;
import codechicken.lib.render.buffer.TransformingVertexConsumer;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.metadata.animation.FrameSize;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceMetadata;

public class RenderUtils {
    public static RenderType FAN_TYPE = RenderType.create((String)"tri_fan_type", (VertexFormat)DefaultVertexFormat.POSITION_COLOR, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLE_FAN, (int)256, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(new RenderStateShard.ShaderStateShard(GameRenderer::getPositionColorShader)).setTransparencyState(RenderStateShard.TRANSLUCENT_TRANSPARENCY).createCompositeState(false));

    @Deprecated
    public static void endBatch(MultiBufferSource getter) {
        if (getter instanceof MultiBufferSource.BufferSource) {
            ((MultiBufferSource.BufferSource)getter).endBatch();
        }
    }

    public static void drawPieProgress(GuiRender render, double x, double y, double diameter, double progress, double offsetAngle, int colour) {
        RenderUtils.drawPieProgress(render, x, y, diameter, progress, offsetAngle, colour, colour);
    }

    public static void drawPieProgress(GuiRender render, double x, double y, double diameter, double progress, double offsetAngle, int innerColour, int outerColour) {
        float radius = (float)diameter / 2.0f;
        TransformingVertexConsumer builder = new TransformingVertexConsumer(render.buffers().getBuffer(FAN_TYPE), render.pose());
        builder.addVertex((float)(x + (double)radius), (float)(y + (double)radius), 0.0f).setColor(innerColour);
        for (double d = 0.0; d <= 1.0; d += 0.03333333333333333) {
            float angle = (float)(d * progress + 0.5 - progress);
            angle *= (float)Math.PI * 2;
            float vertX = (float)(x + (double)radius + Math.sin(angle += (float)Math.PI / 180 * (float)offsetAngle) * (double)radius);
            float vertY = (float)(y + (double)radius + Math.cos(angle) * (double)radius);
            builder.addVertex(vertX, vertY, 0.0f).setColor(outerColour);
        }
    }

    public static Material fromRawTexture(ResourceLocation texture) {
        return new Material(texture, texture, FullSprite::new);
    }

    public static float partialTick() {
        return Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(false);
    }

    private static class FullSprite
    extends TextureAtlasSprite {
        private FullSprite(ResourceLocation location) {
            super(location, new SpriteContents(location, new FrameSize(1, 1), new NativeImage(1, 1, false), ResourceMetadata.EMPTY), 1, 1, 0, 0);
        }

        public float getU(float u) {
            return u / 16.0f;
        }

        public float getV(float v) {
            return v / 16.0f;
        }
    }
}

