/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.command;

import com.brandon3055.brandonscore.BrandonsCore;
import com.brandon3055.brandonscore.client.ClientOnly;
import com.brandon3055.brandonscore.client.gui.ContributorConfigGui;
import com.brandon3055.brandonscore.client.gui.HudConfigGui;
import com.brandon3055.brandonscore.handlers.contributor.ContributorHandler;
import com.brandon3055.brandonscore.handlers.contributor.ContributorProperties;
import com.brandon3055.brandonscore.lib.DelayedTask;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.player.Player;

public class BCClientCommands {
    private static long lastReload = 0L;
    private static long lastLink = 0L;

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder builder = Commands.literal((String)"bcore_client");
        builder.then(BCClientCommands.contributor());
        builder.then(BCClientCommands.hudConfig());
        if (BrandonsCore.inDev) {
            // empty if block
        }
        dispatcher.register(builder);
    }

    private static ArgumentBuilder<CommandSourceStack, ?> hudConfig() {
        return ((LiteralArgumentBuilder)Commands.literal((String)"hudconfig").requires(cs -> cs.hasPermission(0))).executes(context -> {
            DelayedTask.client(10, () -> Minecraft.getInstance().setScreen((Screen)new HudConfigGui.Screen()));
            return 0;
        });
    }

    private static ArgumentBuilder<CommandSourceStack, ?> contributor() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"contributor").requires(cs -> cs.hasPermission(0))).executes(context -> {
            Player player = ClientOnly.getClientPlayer();
            ContributorProperties props = ContributorHandler.getProps(player);
            if (!props.isLoadComplete()) {
                player.sendSystemMessage((Component)Component.literal((String)"Your contributor status has not yet been determined. Please wait a few seconds and try again."));
                return 0;
            }
            if (!props.isContributor()) {
                player.sendSystemMessage((Component)Component.literal((String)"This command allows Draconic Evolution contributors to configure their contributor perks.").withStyle(ChatFormatting.GREEN));
                player.sendSystemMessage((Component)Component.literal((String)"Contributor perks are purely aesthetic features offered to those who support Draconic Evolution.").withStyle(ChatFormatting.GREEN));
                player.sendSystemMessage((Component)Component.literal((String)"You can find more information on my patreon page: ").withStyle(ChatFormatting.GREEN));
                MutableComponent link = Component.literal((String)"www.patreon.com/brandon3055").setStyle(Style.EMPTY.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://www.patreon.com/brandon3055")).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Click to open or copy link"))));
                player.sendSystemMessage((Component)link.withStyle(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.UNDERLINE}));
                player.sendSystemMessage((Component)Component.literal((String)""));
                MutableComponent notLinked = Component.literal((String)"Please Click Here").setStyle(Style.EMPTY.withClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/bcore_client contributor help")).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Click for help"))));
                player.sendSystemMessage((Component)Component.literal((String)"Already a contributor? ").withStyle(ChatFormatting.LIGHT_PURPLE).append((Component)notLinked.withStyle(ChatFormatting.BLUE)));
                return 0;
            }
            DelayedTask.client(10, () -> Minecraft.getInstance().setScreen((Screen)new ContributorConfigGui.Screen(player, props)));
            return 0;
        })).then(Commands.literal((String)"help").executes(context -> {
            Player player = ClientOnly.getClientPlayer();
            player.sendSystemMessage((Component)Component.literal((String)"If you are already a contributor but you you cant access your perks there are several possible causes.").withStyle(ChatFormatting.YELLOW));
            player.sendSystemMessage((Component)Component.literal((String)"Your contributor status might not have have been linked to your Minecraft user id. If you are a patron then you should have received a message with instructions when you signed up. If you are playing in offline mode your contributor status can not be verified. Or your client might not be able to contact the contributor API for some reason.").withStyle(ChatFormatting.GRAY));
            MutableComponent link = Component.literal((String)"DE Discord").setStyle(Style.EMPTY.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://discord.gg/e2HBEtF")).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Click to open or copy link"))));
            player.sendSystemMessage((Component)Component.literal((String)"If you need help you can request assistance via the ").withStyle(ChatFormatting.GREEN).append((Component)link.withStyle(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.UNDERLINE})));
            return 0;
        }))).then(Commands.literal((String)"reload").executes(context -> {
            if (System.currentTimeMillis() - lastReload < 30000L && !BrandonsCore.inDev) {
                Player player = ClientOnly.getClientPlayer();
                player.sendSystemMessage((Component)Component.literal((String)"Please wait at least 30 seconds before running this command again").withStyle(ChatFormatting.RED));
            } else {
                ContributorHandler.reload();
                lastReload = System.currentTimeMillis();
            }
            return 0;
        }))).then(Commands.literal((String)"link").then(Commands.argument((String)"link_code", (ArgumentType)StringArgumentType.string()).executes(context -> {
            Player player = ClientOnly.getClientPlayer();
            if (System.currentTimeMillis() - lastLink < 30000L && !BrandonsCore.inDev) {
                player.sendSystemMessage((Component)Component.literal((String)"Please wait at least 30 seconds before running this command again").withStyle(ChatFormatting.RED));
            } else {
                String linkCode = StringArgumentType.getString((CommandContext)context, (String)"link_code");
                ContributorHandler.linkUser(player, linkCode, error -> {
                    if (error == -1) {
                        player.sendSystemMessage((Component)Component.literal((String)"Link Successful!").withStyle(ChatFormatting.GREEN));
                    } else {
                        player.sendSystemMessage((Component)Component.literal((String)"An error occurred.").withStyle(ChatFormatting.RED));
                        player.sendSystemMessage((Component)Component.literal((String)(error == 404 ? "Invalid Link Code" : "Unknown error code: " + error)).withStyle(ChatFormatting.RED));
                    }
                });
                lastLink = System.currentTimeMillis();
            }
            return 0;
        })));
    }
}

