/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.lib.entityfilter;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import com.brandon3055.brandonscore.lib.entityfilter.EntityFilter;
import com.brandon3055.brandonscore.lib.entityfilter.FilterBase;
import com.brandon3055.brandonscore.lib.entityfilter.FilterType;
import com.mojang.authlib.GameProfile;
import java.util.regex.Pattern;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class FilterPlayer
extends FilterBase {
    public static Pattern namePattern = Pattern.compile("^[\\w]*$");
    protected boolean whitelistPlayers = true;
    private String playerName = "";
    private String playerUUID = "";

    public FilterPlayer(EntityFilter filter) {
        super(filter);
    }

    public void setWhitelistPlayers(boolean whitelistPlayers) {
        boolean prev = this.whitelistPlayers;
        this.whitelistPlayers = whitelistPlayers;
        this.getFilter().nodeModified(this);
        this.whitelistPlayers = prev;
    }

    public void setPlayerName(String playerName) {
        this.playerName = playerName;
        this.playerUUID = "";
        this.getFilter().nodeModified(this);
    }

    public boolean isWhitelistPlayers() {
        return this.whitelistPlayers;
    }

    public String getPlayerName() {
        return this.playerName;
    }

    @Override
    public boolean test(Entity entity) {
        boolean isPlayer = entity instanceof Player;
        if (isPlayer) {
            if (this.playerName.isEmpty()) {
                return this.whitelistPlayers;
            }
            return this.isPlayerMatch((Player)entity) == this.whitelistPlayers;
        }
        return !this.whitelistPlayers;
    }

    private boolean isPlayerMatch(Player player) {
        GameProfile profile;
        if (!(player instanceof ServerPlayer)) {
            return player.getGameProfile().getName().equalsIgnoreCase(this.playerName);
        }
        if (!this.playerUUID.isEmpty()) {
            return player.getUUID().toString().equals(this.playerUUID);
        }
        MinecraftServer server = player.getServer();
        if (server != null && (profile = (GameProfile)server.getProfileCache().get(this.playerName).orElse(null)) != null) {
            this.playerUUID = profile.getId().toString();
            return player.getUUID().toString().equals(this.playerUUID);
        }
        return player.getGameProfile().getName().equalsIgnoreCase(this.playerName);
    }

    @Override
    public FilterType getType() {
        return FilterType.PLAYER;
    }

    @Override
    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag compound = super.serializeNBT(provider);
        compound.putBoolean("include", this.whitelistPlayers);
        compound.putString("name", this.playerName);
        compound.putString("uuid", this.playerUUID);
        return compound;
    }

    @Override
    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        super.deserializeNBT(provider, nbt);
        this.whitelistPlayers = nbt.getBoolean("include");
        this.playerName = nbt.getString("name");
        this.playerUUID = nbt.getString("uuid");
    }

    @Override
    public void serializeMCD(MCDataOutput output) {
        super.serializeMCD(output);
        output.writeBoolean(this.whitelistPlayers);
        output.writeString(this.playerName);
        output.writeString(this.playerUUID);
    }

    @Override
    public void deSerializeMCD(MCDataInput input) {
        super.deSerializeMCD(input);
        this.whitelistPlayers = input.readBoolean();
        this.playerName = input.readString();
        this.playerUUID = input.readString();
        if (!namePattern.matcher(this.playerName).find()) {
            this.playerName = "";
        }
    }
}

