/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.texture.ctx;

import com.google.common.base.Preconditions;
import java.util.EnumMap;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import team.chisel.ctm.client.texture.ctx.TextureContextPosition;
import team.chisel.ctm.client.texture.render.TextureMap;
import team.chisel.ctm.client.util.FaceOffset;

@ParametersAreNonnullByDefault
public abstract class TextureContextGrid
extends TextureContextPosition {
    private final EnumMap<Direction, Point2i> textureCoords = new EnumMap(Direction.class);
    private final long serialized;

    public TextureContextGrid(BlockAndTintGetter world, BlockPos pos, TextureMap tex, boolean applyOffset) {
        super(pos);
        Preconditions.checkArgument((tex.getXSize() * tex.getYSize() < 1024 ? 1 : 0) != 0, (String)"V* Texture size too large for texture %s", (Object)tex.getParticle());
        if (applyOffset) {
            this.applyOffset(world);
        }
        long serialized = 0L;
        for (Direction side : Direction.values()) {
            BlockPos modifiedPosition = this.position.offset((Vec3i)FaceOffset.getBlockPosOffsetFromFaceOffset(side, tex.getXOffset(), tex.getYOffset()));
            Point2i coords = this.calculateTextureCoord(modifiedPosition, tex.getXSize(), tex.getYSize(), side);
            this.textureCoords.put(side, coords);
            serialized |= (long)coords.x + (long)coords.y * (long)tex.getXSize() << 10 * side.ordinal();
        }
        this.serialized = serialized;
    }

    protected abstract Point2i calculateTextureCoord(BlockPos var1, int var2, int var3, Direction var4);

    public Point2i getTextureCoords(Direction side) {
        return this.textureCoords.get(side);
    }

    @Override
    public long getCompressedData() {
        return this.serialized;
    }

    public record Point2i(int x, int y) {
    }

    public static class Random
    extends TextureContextGrid {
        private static final java.util.Random rand = new java.util.Random();

        public Random(BlockAndTintGetter world, BlockPos pos, TextureMap tex, boolean applyOffset) {
            super(world, pos, tex, applyOffset);
        }

        @Override
        protected Point2i calculateTextureCoord(BlockPos pos, int w, int h, Direction side) {
            rand.setSeed(Mth.getSeed((Vec3i)pos) + (long)side.ordinal());
            rand.nextBoolean();
            int tx = rand.nextInt(w) + 1;
            int ty = rand.nextInt(h) + 1;
            return new Point2i(tx, ty);
        }
    }

    public static class Patterned
    extends TextureContextGrid {
        public Patterned(BlockAndTintGetter world, BlockPos pos, TextureMap tex, boolean applyOffset) {
            super(world, pos, tex, applyOffset);
        }

        @Override
        protected Point2i calculateTextureCoord(BlockPos pos, int w, int h, Direction side) {
            int ty;
            int tx;
            int x = pos.getX();
            int y = pos.getY();
            int z = pos.getZ();
            if (side.getAxis().isVertical()) {
                tx = x % w;
                ty = (side.getStepY() * z + 1) % h;
            } else if (side.getAxis() == Direction.Axis.Z) {
                tx = x % w;
                ty = -y % h;
            } else {
                tx = (z + 1) % w;
                ty = -y % h;
            }
            if (side == Direction.NORTH || side == Direction.EAST) {
                tx = (w - tx - 1) % w;
            }
            if (tx < 0) {
                tx += w;
            }
            if (ty < 0) {
                ty += h;
            }
            return new Point2i(tx, ty);
        }
    }
}

