/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.gui.impl.carbon;

import carbonconfiglib.api.IEntrySettings;
import carbonconfiglib.api.IReloadMode;
import carbonconfiglib.api.ISuggestionProvider;
import carbonconfiglib.gui.api.DataType;
import carbonconfiglib.gui.api.IArrayNode;
import carbonconfiglib.gui.api.INode;
import carbonconfiglib.gui.impl.carbon.CarbonCompound;
import carbonconfiglib.gui.impl.carbon.CarbonValue;
import carbonconfiglib.gui.impl.carbon.IValueActions;
import carbonconfiglib.impl.ReloadMode;
import carbonconfiglib.utils.Helpers;
import carbonconfiglib.utils.ParseResult;
import carbonconfiglib.utils.structure.IStructuredData;
import carbonconfiglib.utils.structure.StructureList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import speiger.src.collections.objects.lists.ObjectArrayList;
import speiger.src.collections.objects.lists.ObjectList;
import speiger.src.collections.utils.Stack;

public class CarbonArray
implements IArrayNode,
IValueActions {
    IReloadMode mode;
    StructureList.ListData data;
    IStructuredData inner;
    Component name;
    Component tooltip;
    Function<String, ParseResult<Boolean>> isValid;
    Supplier<List<ISuggestionProvider.Suggestion>> suggestions;
    BiConsumer<String, IValueActions> saveAction;
    List<IValueActions> values = new ObjectArrayList();
    Stack<List<String>> previous = new ObjectArrayList();
    ObjectList<String> currentValues;
    List<String> defaults;

    public CarbonArray(IReloadMode mode, StructureList.ListData data, Component name, Component tooltip, String currentValue, String defaultValue, Function<String, ParseResult<Boolean>> isValid, Supplier<List<ISuggestionProvider.Suggestion>> suggestions, BiConsumer<String, IValueActions> saveAction) {
        this.mode = mode;
        this.data = data;
        this.inner = data.getType();
        this.name = name;
        this.tooltip = tooltip;
        this.currentValues = ObjectArrayList.wrap((Object[])Helpers.splitCompoundArray(currentValue));
        this.defaults = ObjectArrayList.wrap((Object[])Helpers.splitCompoundArray(defaultValue));
        this.previous.push((Object)new ObjectArrayList(this.currentValues));
        this.isValid = isValid;
        this.suggestions = suggestions;
        this.saveAction = saveAction;
        this.reload();
    }

    public void reload() {
        this.values.clear();
        int m = this.currentValues.size();
        for (int i = 0; i < m; ++i) {
            this.values.add(this.addEntry(Helpers.removeLayer((String)this.currentValues.get(i), 0), i >= this.defaults.size() ? "" : Helpers.removeLayer(this.defaults.get(i), 0), i));
        }
    }

    protected IValueActions addEntry(String value, String defaultValue, int index) {
        switch (this.inner.getDataType()) {
            case COMPOUND: {
                return new CarbonCompound(this.mode, this.inner.asCompound(), (Component)this.name.copy().append(" " + index + ":"), this.tooltip, value, defaultValue, this::isValid, () -> this.data.getSuggestions(T -> true), this::save);
            }
            case LIST: {
                return new CarbonArray(this.mode, this.inner.asList(), (Component)this.name.copy().append(" " + index + ":"), this.tooltip, value, defaultValue, this::isValid, () -> this.data.getSuggestions(T -> true), this::save);
            }
            case SIMPLE: {
                return new CarbonValue(this.mode, (Component)this.name.copy().append(" " + index + ":"), this.tooltip, null, DataType.bySimple(this.inner.asSimple()), false, () -> this.data.getSuggestions(T -> true), value, defaultValue, this::isValid, this::save);
            }
        }
        return null;
    }

    protected ParseResult<Boolean> isValid(String value) {
        return this.isValid.apply(value);
    }

    protected void save(String value, IValueActions actions) {
        int index = this.values.indexOf(actions);
        if (index == -1) {
            return;
        }
        this.currentValues.set(index, (Object)value);
    }

    protected List<String> getPrev() {
        return (List)this.previous.top();
    }

    @Override
    public void set(String value) {
        this.currentValues.clear();
        this.currentValues.addAll((Object[])Helpers.splitCompoundArray(value));
    }

    @Override
    public void save() {
        this.saveAction.accept(this.inner.getDataType() == IStructuredData.StructureType.COMPOUND ? Helpers.mergeCompoundArray(this.currentValues, false, 0) : String.join((CharSequence)", ", this.currentValues), this);
    }

    @Override
    public boolean isChanged() {
        return !this.getPrev().equals(this.currentValues);
    }

    @Override
    public boolean isDefault() {
        return this.currentValues.equals(this.defaults);
    }

    @Override
    public void setPrevious() {
        this.currentValues.clear();
        this.currentValues.addAll(this.getPrev());
        if (this.previous.size() > 1) {
            this.previous.pop();
        }
        this.reload();
    }

    @Override
    public void setDefault() {
        this.currentValues.clear();
        this.currentValues.addAll(this.defaults);
        this.reload();
    }

    @Override
    public void moveDown(int index) {
        this.swapValues(index, index + 1);
    }

    @Override
    public void moveUp(int index) {
        this.swapValues(index, index - 1);
    }

    private void swapValues(int from, int to) {
        if (from >= this.values.size() || from < 0) {
            return;
        }
        if (to >= this.values.size() || to < 0) {
            return;
        }
        this.currentValues.set(from, (Object)((String)this.currentValues.set(to, (Object)((String)this.currentValues.get(from)))));
        this.values.get(from).set((String)this.currentValues.get(from));
        this.values.get(to).set((String)this.currentValues.get(to));
    }

    @Override
    public void createTemp() {
        this.previous.push((Object)new ObjectArrayList(this.currentValues));
        this.reload();
    }

    @Override
    public void apply() {
        if (this.previous.size() > 1) {
            this.previous.pop();
        }
        int m = this.currentValues.size();
        for (int i = 0; i < m; ++i) {
            this.values.get(i).save();
        }
    }

    @Override
    public void createNode() {
        String defaultString = this.defaults.isEmpty() ? this.inner.generateDefaultValue(this::getDefaultValue) : this.defaults.get(0);
        int index = this.currentValues.size();
        this.currentValues.add((Object)defaultString);
        this.values.add(this.addEntry(defaultString, "", index));
    }

    private String getDefaultValue(IStructuredData.SimpleData data) {
        return DataType.bySimple(data).getDefaultValue();
    }

    @Override
    public void removeNode(int index) {
        this.values.remove(index);
        this.currentValues.remove(index);
    }

    @Override
    public int indexOf(INode value) {
        return this.values.indexOf(value);
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public INode get(int index) {
        return this.values.get(index);
    }

    @Override
    public IStructuredData.StructureType getInnerType() {
        return this.inner.getDataType();
    }

    @Override
    public IStructuredData.StructureType getNodeType() {
        return IStructuredData.StructureType.LIST;
    }

    @Override
    public IEntrySettings getSettings() {
        return this.data.getSettings();
    }

    @Override
    public boolean requiresRestart() {
        return this.mode == ReloadMode.GAME;
    }

    @Override
    public boolean requiresReload() {
        return this.mode == ReloadMode.WORLD;
    }

    @Override
    public Component getName() {
        return this.name;
    }

    @Override
    public Component getTooltip() {
        return this.tooltip;
    }

    @Override
    public List<ISuggestionProvider.Suggestion> getSuggestions() {
        return this.suggestions.get();
    }
}

