/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.gui.screen;

import carbonconfiglib.gui.api.BackgroundTexture;
import carbonconfiglib.gui.api.IConfigNode;
import carbonconfiglib.gui.api.IModConfig;
import carbonconfiglib.gui.api.INode;
import carbonconfiglib.gui.api.IValueNode;
import carbonconfiglib.gui.config.ArrayElement;
import carbonconfiglib.gui.config.CompoundElement;
import carbonconfiglib.gui.config.ConfigElement;
import carbonconfiglib.gui.config.Element;
import carbonconfiglib.gui.config.FolderElement;
import carbonconfiglib.gui.config.ListScreen;
import carbonconfiglib.gui.config.SelectionElement;
import carbonconfiglib.gui.screen.MultiChoiceScreen;
import carbonconfiglib.gui.widgets.CarbonButton;
import carbonconfiglib.gui.widgets.CarbonIconCheckbox;
import carbonconfiglib.gui.widgets.GuiUtils;
import carbonconfiglib.gui.widgets.Icon;
import it.unimi.dsi.fastutil.PriorityQueue;
import it.unimi.dsi.fastutil.objects.ObjectArrayFIFOQueue;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.neoforged.fml.ModList;

public class ConfigScreen
extends ListScreen {
    private static final Comparator<Element> SORTER = (K, V) -> {
        int sort = (V instanceof FolderElement ? 1 : 0) - (K instanceof FolderElement ? 1 : 0);
        return sort != 0 ? sort : String.CASE_INSENSITIVE_ORDER.compare(K.getName(), V.getName());
    };
    Screen parent;
    IModConfig config;
    IConfigNode node;
    CarbonIconCheckbox deepSearch;
    CarbonIconCheckbox onlyChanged;
    CarbonIconCheckbox onlyNonDefault;
    boolean wasChanged = false;
    Navigator nav;
    List<Element> cache = null;

    public ConfigScreen(IModConfig config, Screen parent) {
        this(Navigator.create(config), config, parent);
    }

    public ConfigScreen(Navigator nav, IModConfig config, Screen parent) {
        this(nav, config, parent, BackgroundTexture.DEFAULT.asHolder());
    }

    public ConfigScreen(Navigator nav, IModConfig config, Screen parent, BackgroundTexture.BackgroundHolder customTexture) {
        super((Component)Component.empty(), customTexture);
        this.nav = nav;
        this.config = config;
        this.node = config.getRootNode();
        this.parent = parent;
        this.nav.setScreenForLayer(this);
    }

    public ConfigScreen(Navigator nav, IConfigNode node, Screen parent, BackgroundTexture.BackgroundHolder customTexture) {
        super((Component)Component.empty(), customTexture);
        this.nav = nav;
        this.node = node;
        this.parent = parent;
        this.nav.setScreenForLayer(this);
    }

    @Override
    protected void init() {
        String walkNode;
        super.init();
        int x = this.width / 2 - 100;
        int y = this.height;
        if (this.node.isRoot()) {
            this.addRenderableWidget((GuiEventListener)new CarbonButton(x - 51, y - 27, 100, 20, (Component)Component.translatable((String)"gui.carbonconfig.save"), this::save));
            this.addRenderableWidget((GuiEventListener)new CarbonButton(x + 51, y - 27, 100, 20, (Component)Component.translatable((String)"gui.carbonconfig.reset"), this::reset));
            this.addRenderableWidget((GuiEventListener)new CarbonButton(x + 153, y - 27, 100, 20, (Component)Component.translatable((String)"gui.carbonconfig.back"), this::goBack));
        } else {
            this.addRenderableWidget((GuiEventListener)new CarbonButton(x + 101, y - 27, 100, 20, (Component)Component.translatable((String)"gui.carbonconfig.back"), this::goBack));
            this.addRenderableWidget((GuiEventListener)new CarbonButton(x - 1, y - 27, 100, 20, (Component)Component.translatable((String)"gui.carbonconfig.home"), this::goToRoot));
        }
        if (this.shouldHaveSearch()) {
            this.deepSearch = (CarbonIconCheckbox)this.addRenderableWidget((GuiEventListener)new CarbonIconCheckbox(x + 205, 25, 20, 20, Icon.SEARCH_SELECTED, Icon.SEARCH, false).withListener(this::onDeepSearch).setTooltip(this, "gui.carbonconfig.deepsearch"));
            this.onlyChanged = (CarbonIconCheckbox)this.addRenderableWidget((GuiEventListener)new CarbonIconCheckbox(x + 227, 25, 20, 20, Icon.SET_DEFAULT, Icon.REVERT, false).withListener(this::onChangedButton).setTooltip(this, "gui.carbonconfig.changed_only"));
            this.onlyNonDefault = (CarbonIconCheckbox)this.addRenderableWidget((GuiEventListener)new CarbonIconCheckbox(x + 249, 25, 20, 20, Icon.NOT_DEFAULT_SELECTED, Icon.NOT_DEFAULT, false).withListener(this::onDefaultButton).setTooltip(this, "gui.carbonconfig.default_only"));
        }
        if ((walkNode = this.nav.getWalkNode()) != null) {
            FolderElement element = this.getElement(walkNode);
            if (element != null) {
                element.onPress(null);
            }
            this.nav.consumeWalker();
        }
    }

    private void onDeepSearch() {
        if (this.onlyChanged.selected() || this.onlyNonDefault.selected()) {
            this.deepSearch.setSelected(false);
        } else {
            this.wasChanged = true;
        }
    }

    private void onChangedButton() {
        this.deepSearch.setSelected(false);
        this.onlyNonDefault.setSelected(false);
    }

    private void onDefaultButton() {
        this.deepSearch.setSelected(false);
        this.onlyChanged.setSelected(false);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.shouldHaveSearch() && (this.onlyChanged.selected() || this.onlyNonDefault.selected() || this.wasChanged)) {
            this.onSearchChange(this.searchBox, this.searchBox.getValue().toLowerCase(Locale.ROOT));
            this.wasChanged = this.onlyChanged.selected() || this.onlyNonDefault.selected();
        }
    }

    @Override
    public void handleForground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        GuiUtils.drawScrollingString(graphics, this.font, this.nav.getHeader(), 50.0f, 6.0f, this.width - 100, 10.0f, ConfigElement.GuiAlign.CENTER, -1, 0);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (mouseX >= 50.0 && mouseX <= (double)(this.width - 100) && mouseY >= 6.0 && mouseY <= 16.0) {
            float scroll = GuiUtils.calculateScrollOffset(this.width - 100, this.font, ConfigElement.GuiAlign.CENTER, this.nav.getHeader(), 0);
            Screen screen = this.nav.getScreen(this.font, (int)(mouseX - (double)ConfigElement.GuiAlign.CENTER.align(50, this.width - 100, this.font.width((FormattedText)this.nav.getHeader())) - (double)scroll));
            if (screen instanceof ConfigScreen) {
                this.minecraft.setScreen(screen);
                return true;
            }
            if (screen != null) {
                this.leave();
                return true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    protected List<Element> sortElements(List<Element> list) {
        list.sort(SORTER);
        return list;
    }

    private void goToRoot(Button button) {
        ConfigScreen prev = this;
        ConfigScreen parent = this;
        while (parent instanceof ConfigScreen) {
            prev = parent;
            parent = parent.parent;
        }
        if (prev != this) {
            this.minecraft.setScreen((Screen)prev);
        }
    }

    private void leave() {
        ConfigScreen prev = this;
        ConfigScreen parent = this;
        while (parent instanceof ConfigScreen) {
            prev = parent;
            parent = parent.parent;
        }
        if (prev != this) {
            Screen toOpen = prev.parent;
            if (this.node.isRoot() && prev.isChanged()) {
                this.minecraft.setScreen((Screen)new ConfirmScreen(T -> this.minecraft.setScreen((Screen)(T ? toOpen : this)), (Component)Component.translatable((String)"gui.carbonconfig.warn.changed"), (Component)Component.translatable((String)"gui.carbonconfig.warn.changed.desc").withStyle(ChatFormatting.GRAY)));
                return;
            }
            this.minecraft.setScreen(toOpen);
        }
    }

    private void reset(Button button) {
        this.minecraft.setScreen((Screen)new MultiChoiceScreen(T -> {
            if (T.isMain()) {
                this.processAction(IConfigNode::setDefault);
            } else if (T.isOther()) {
                this.processAction(IConfigNode::setPrevious);
            }
            this.minecraft.setScreen((Screen)this);
        }, (Component)Component.translatable((String)"gui.carbonconfig.reset_all.title"), (Component)Component.translatable((String)"gui.carbonconfig.reset_all.message").withStyle(ChatFormatting.GRAY), (Component)Component.translatable((String)"gui.carbonconfig.reset_all.default"), (Component)Component.translatable((String)"gui.carbonconfig.reset_all.reset"), (Component)Component.translatable((String)"gui.carbonconfig.reset_all.cancel")));
    }

    private void save(Button button) {
        List<IConfigNode> value = this.processedChanged(IConfigNode::save);
        this.config.save();
        if (this.findFirst(IConfigNode::requiresRestart, value)) {
            MultiChoiceScreen choice = new MultiChoiceScreen(T -> this.minecraft.setScreen(this.parent), (Component)Component.translatable((String)"gui.carbonconfig.restart.title"), (Component)Component.translatable((String)"gui.carbonconfig.restart.message").withStyle(ChatFormatting.GRAY), (Component)Component.translatable((String)"gui.carbonconfig.ok"));
            this.minecraft.setScreen((Screen)choice);
            return;
        }
        if (this.minecraft.level != null && this.findFirst(IConfigNode::requiresReload, value)) {
            MultiChoiceScreen choice = new MultiChoiceScreen(T -> this.minecraft.setScreen(this.parent), (Component)Component.translatable((String)"gui.carbonconfig.reload.title"), (Component)Component.translatable((String)"gui.carbonconfig.reload.message").withStyle(ChatFormatting.GRAY), (Component)Component.translatable((String)"gui.carbonconfig.ok"));
            this.minecraft.setScreen((Screen)choice);
            return;
        }
        this.minecraft.setScreen(this.parent);
    }

    private <T> boolean findFirst(Predicate<T> filter, List<T> elements) {
        int m = elements.size();
        for (int i = 0; i < m; ++i) {
            if (!filter.test(elements.get(i))) continue;
            return true;
        }
        return false;
    }

    private List<IConfigNode> processedChanged(Consumer<IConfigNode> action) {
        ObjectArrayList output = new ObjectArrayList();
        ObjectArrayFIFOQueue nodes = new ObjectArrayFIFOQueue();
        nodes.enqueue((Object)this.node);
        while (!nodes.isEmpty()) {
            IConfigNode node = (IConfigNode)nodes.dequeue();
            if (!node.isLeaf()) {
                node.getChildren().forEach(arg_0 -> ((PriorityQueue)nodes).enqueue(arg_0));
                continue;
            }
            if (!node.isChanged()) continue;
            action.accept(node);
            output.add(node);
        }
        return output;
    }

    private void processAction(Consumer<IConfigNode> action) {
        ObjectArrayFIFOQueue nodes = new ObjectArrayFIFOQueue();
        nodes.enqueue((Object)this.node);
        while (!nodes.isEmpty()) {
            IConfigNode node = (IConfigNode)nodes.dequeue();
            if (!node.isLeaf()) {
                node.getChildren().forEach(arg_0 -> ((PriorityQueue)nodes).enqueue(arg_0));
                continue;
            }
            action.accept(node);
        }
    }

    @Override
    protected void onSearchChange(EditBox box, String value) {
        if (!(this.deepSearch.selected() && !value.isEmpty() || this.onlyChanged.selected() || this.onlyNonDefault.selected())) {
            super.onSearchChange(box, value);
            return;
        }
        if (this.cache == null) {
            this.cache = this.sortElements(ConfigScreen.getAllElements(this.node));
            this.cache.forEach(x$0 -> this.addInternal((Element)((Object)x$0)));
        }
        if (this.onlyNonDefault.selected()) {
            ObjectArrayList subCache = new ObjectArrayList();
            for (Element element : this.cache) {
                if (element.isDefault()) continue;
                subCache.add(element);
            }
            super.onSearchChange(box, value, (List<Element>)subCache);
            return;
        }
        if (this.onlyChanged.selected()) {
            ObjectArrayList subCache = new ObjectArrayList();
            for (Element element : this.cache) {
                if (!element.isChanged()) continue;
                subCache.add(element);
            }
            super.onSearchChange(box, value, (List<Element>)subCache);
            return;
        }
        super.onSearchChange(box, value, this.cache);
    }

    private void goBack(Button button) {
        if (this.node.isRoot() && this.isChanged()) {
            this.minecraft.setScreen((Screen)new ConfirmScreen(T -> this.minecraft.setScreen((Screen)(T ? this.parent : this)), (Component)Component.translatable((String)"gui.carbonconfig.warn.changed"), (Component)Component.translatable((String)"gui.carbonconfig.warn.changed.desc").withStyle(ChatFormatting.GRAY)));
            return;
        }
        this.minecraft.setScreen(this.parent);
    }

    private boolean isChanged() {
        ObjectArrayFIFOQueue nodes = new ObjectArrayFIFOQueue();
        nodes.enqueue((Object)this.node);
        while (!nodes.isEmpty()) {
            IConfigNode node = (IConfigNode)nodes.dequeue();
            if (!node.isLeaf()) {
                node.getChildren().forEach(arg_0 -> ((PriorityQueue)nodes).enqueue(arg_0));
                continue;
            }
            if (!node.isChanged()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected int getListWidth() {
        return 340;
    }

    @Override
    protected int getScrollPadding() {
        return 175;
    }

    @Override
    protected void collectElements(Consumer<Element> elements) {
        for (IConfigNode child : this.node.getChildren()) {
            if (child.isLeaf()) {
                switch (child.getDataStructure()) {
                    case COMPOUND: {
                        elements.accept(new CompoundElement(INode.asCompound(child)));
                        break;
                    }
                    case LIST: {
                        elements.accept(new ArrayElement(INode.asArray(child)));
                        break;
                    }
                    case SIMPLE: {
                        IValueNode node = INode.asValue(child);
                        if (node == null) break;
                        if (node.isForcingSuggestions()) {
                            elements.accept(new SelectionElement(node));
                            break;
                        }
                        ConfigElement element = node.getDataType().create(node);
                        if (element == null) break;
                        elements.accept(element);
                    }
                }
                continue;
            }
            elements.accept(new FolderElement(child, this.nav));
        }
    }

    private static List<Element> getAllElements(IConfigNode init) {
        ObjectArrayFIFOQueue nodes = new ObjectArrayFIFOQueue();
        nodes.enqueue((Object)init);
        ObjectArrayList results = new ObjectArrayList();
        while (!nodes.isEmpty()) {
            IConfigNode node = (IConfigNode)nodes.dequeue();
            if (!node.isLeaf()) {
                node.getChildren().forEach(arg_0 -> ((PriorityQueue)nodes).enqueue(arg_0));
                continue;
            }
            switch (node.getDataStructure()) {
                case COMPOUND: {
                    results.add(new CompoundElement(INode.asCompound(node)));
                    break;
                }
                case LIST: {
                    results.add(new ArrayElement(INode.asArray(node)));
                    break;
                }
                case SIMPLE: {
                    IValueNode value = INode.asValue(node);
                    if (value == null) break;
                    if (value.isForcingSuggestions()) {
                        results.add(new SelectionElement(value));
                        break;
                    }
                    ConfigElement element = value.getDataType().create(value);
                    if (element == null) break;
                    results.add(element);
                }
            }
        }
        return results;
    }

    public FolderElement getElement(String name) {
        for (Element element : this.allEntries) {
            FolderElement folder;
            if (!(element instanceof FolderElement) || (folder = (FolderElement)element).getNode() == null || !name.equalsIgnoreCase(folder.getNode().getNodeName())) continue;
            return folder;
        }
        return null;
    }

    public static class Navigator {
        private static final Component SPLITTER = Component.literal((String)" > ").withStyle(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD});
        List<Component> layer = new ObjectArrayList();
        List<Screen> screenByIndex = new ObjectArrayList();
        List<String> walker = null;
        MutableComponent buildCache = null;

        private Navigator() {
        }

        public Navigator(Component base) {
            this.layer.add(base);
        }

        public static Navigator create(IModConfig config) {
            Navigator nav = new Navigator((Component)Component.literal((String)ModList.get().getModContainerById(config.getModId()).map(T -> T.getModInfo().getDisplayName()).orElse("Unknown")));
            nav.setScreenForLayer(null);
            return nav.add((Component)Component.translatable((String)("gui.carbonconfig.type." + config.getConfigType().name().toLowerCase())));
        }

        public Navigator add(Component name) {
            return this.add(name, null);
        }

        public Navigator add(Component name, String walkerEntry) {
            Navigator nav = new Navigator();
            nav.layer.addAll(this.layer);
            nav.screenByIndex.addAll(this.screenByIndex);
            nav.layer.add(name);
            if (this.walker != null && this.walker.size() > 1 && walkerEntry != null && this.walker.indexOf(walkerEntry.toLowerCase(Locale.ROOT)) == 0) {
                nav.walker = new ObjectArrayList();
                for (int i = 1; i < this.walker.size(); ++i) {
                    nav.walker.add(this.walker.get(i));
                }
            }
            return nav;
        }

        public Navigator withWalker(String ... traversePath) {
            this.walker = new ObjectArrayList();
            for (String path : traversePath) {
                this.walker.add(path.toLowerCase(Locale.ROOT));
            }
            return this;
        }

        public void setScreenForLayer(Screen owner) {
            if (this.layer.size() > this.screenByIndex.size()) {
                this.screenByIndex.add(owner);
            } else {
                this.screenByIndex.set(this.layer.size() - 1, owner);
            }
        }

        public Screen getScreen(Font font, int x) {
            int splitterWidth = font.width((FormattedText)SPLITTER);
            int m = this.layer.size();
            for (int i = 0; i < m; ++i) {
                int width = font.width((FormattedText)this.layer.get(i));
                if (x >= 0 && x <= width) {
                    return this.screenByIndex.get(i);
                }
                x -= width;
                x -= splitterWidth;
            }
            return null;
        }

        protected void consumeWalker() {
            this.walker = null;
        }

        protected String getWalkNode() {
            return this.walker == null ? null : this.walker.get(0);
        }

        public Component getHeader() {
            if (this.buildCache == null) {
                this.buildCache = Component.empty();
                int m = this.layer.size();
                for (int i = 0; i < m; ++i) {
                    this.buildCache.append(this.layer.get(i));
                    if (i == m - 1) continue;
                    this.buildCache.append(SPLITTER);
                }
            }
            return this.buildCache;
        }
    }
}

