/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.items;

import chanceCubes.blocks.CCubesBlocks;
import chanceCubes.client.ClientHelper;
import chanceCubes.client.listeners.RenderEvent;
import chanceCubes.items.BaseChanceCubesItem;
import chanceCubes.items.ItemChancePendant;
import chanceCubes.network.PacketCubeScan;
import chanceCubes.tileentities.TileChanceCube;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class ItemScanner
extends BaseChanceCubesItem {
    public ItemScanner() {
        super(new Item.Properties().stacksTo(1));
    }

    public int getUseDuration(ItemStack stack, LivingEntity livingEntity) {
        return 72000;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int p_41407_, boolean isSelected) {
        if (!level.isClientSide()) {
            return;
        }
        if (entity instanceof Player) {
            BlockHitResult movingobjectposition;
            Player player = (Player)entity;
            RenderEvent.setLookingAt(false);
            if (isSelected && (movingobjectposition = Item.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE)).getType() == HitResult.Type.BLOCK) {
                double i = movingobjectposition.getBlockPos().getX();
                double j = movingobjectposition.getBlockPos().getY();
                double k = movingobjectposition.getBlockPos().getZ();
                boolean flag = false;
                BlockPos position = BlockPos.containing((double)i, (double)j, (double)k);
                if (level.getBlockState(position).getBlock().equals(CCubesBlocks.CHANCE_CUBE.get())) {
                    TileChanceCube te = (TileChanceCube)level.getBlockEntity(BlockPos.containing((double)i, (double)j, (double)k));
                    if (te != null) {
                        te.setScanned(true);
                        ClientHelper.sendToServer(new PacketCubeScan(te.getBlockPos()));
                        flag = true;
                        RenderEvent.setLookingAtChance(te.getChance());
                    }
                } else if (level.getBlockState(position).getBlock().equals(CCubesBlocks.GIANT_CUBE.get())) {
                    RenderEvent.setLookingAtChance(-201);
                    RenderEvent.setLookingAt(true);
                    RenderEvent.setChanceIncrease(0);
                }
                if (flag) {
                    RenderEvent.setLookingAt(true);
                    int chanceInc = 0;
                    for (ItemStack s : player.getInventory().items) {
                        if (s.isEmpty() || !(s.getItem() instanceof ItemChancePendant)) continue;
                        chanceInc += ((ItemChancePendant)s.getItem()).getChanceIncrease();
                        break;
                    }
                    RenderEvent.setChanceIncrease(chanceInc);
                }
            }
        }
    }
}

