/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.defaultRewards;

import chanceCubes.blocks.BlockFallingCustom;
import chanceCubes.config.CCubesSettings;
import chanceCubes.rewards.defaultRewards.BossBaseReward;
import chanceCubes.rewards.rewardparts.OffsetBlock;
import chanceCubes.util.RewardsUtil;
import chanceCubes.util.Scheduler;
import chanceCubes.util.Task;
import com.google.gson.JsonObject;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class BossRavagerReward
extends BossBaseReward {
    private ArmorStand armorStandEntity;

    public BossRavagerReward() {
        super("ravager");
    }

    @Override
    public LivingEntity initBoss(final ServerLevel level, BlockPos pos, final Player player, JsonObject settings, BossBaseReward.BattleWrapper battleWrapper) {
        final Ravager ravager = (Ravager)EntityType.RAVAGER.create((Level)level);
        this.armorStandEntity = (ArmorStand)EntityType.ARMOR_STAND.create((Level)level);
        this.armorStandEntity.setInvulnerable(true);
        this.armorStandEntity.startRiding((Entity)ravager, true);
        level.addFreshEntity((Entity)this.armorStandEntity);
        ItemStack headStack = new ItemStack((ItemLike)Items.PLAYER_HEAD);
        headStack.set(DataComponents.PROFILE, (Object)new ResolvableProfile(player.getGameProfile()));
        this.armorStandEntity.setItemSlot(EquipmentSlot.HEAD, headStack);
        this.armorStandEntity.setItemSlot(EquipmentSlot.CHEST, new ItemStack((ItemLike)Items.DIAMOND_CHESTPLATE));
        this.armorStandEntity.setItemSlot(EquipmentSlot.LEGS, new ItemStack((ItemLike)Items.DIAMOND_LEGGINGS));
        this.armorStandEntity.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.DIAMOND_HOE));
        this.armorStandEntity.setItemSlot(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Items.SHIELD));
        Scheduler.scheduleTask(new Task("witch_abilities", -1, 20){

            @Override
            public void callback() {
            }

            @Override
            public void update() {
                if (!ravager.isAlive()) {
                    Scheduler.removeTask(this);
                    return;
                }
                if (RewardsUtil.rand.nextInt(20) == 4) {
                    BossRavagerReward.this.groundPound(ravager.getOnPos(), level);
                }
                if (RewardsUtil.rand.nextInt(10) == 4) {
                    BossRavagerReward.this.charge(ravager, player);
                }
            }
        });
        return ravager;
    }

    private void groundPound(final BlockPos ravagerPos, final ServerLevel level) {
        Scheduler.scheduleTask(new Task("ground_pound_ability", -1, 5){
            int radius;
            {
                super(name, delay, updateTick);
                this.radius = 3;
            }

            @Override
            public void callback() {
            }

            @Override
            public void update() {
                BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(0, 0, 0);
                for (int x = -this.radius; x <= this.radius; ++x) {
                    for (int z = -this.radius; z <= this.radius; ++z) {
                        pos.set(x, 0, z);
                        if (!BossRavagerReward.this.withinDistance((BlockPos)pos, this.radius)) continue;
                        BlockPos newPos = ravagerPos.offset((Vec3i)pos);
                        BlockState state = level.getBlockState(newPos);
                        if (CCubesSettings.nonReplaceableBlocks.contains(state) || state.getBlock().equals(Blocks.AIR)) {
                            state = Blocks.DIRT.defaultBlockState();
                        } else {
                            level.setBlockAndUpdate(newPos, Blocks.AIR.defaultBlockState());
                        }
                        BlockFallingCustom block = new BlockFallingCustom((Level)level, (double)newPos.getX() + 0.5, newPos.getY(), (double)newPos.getZ() + 0.5, state, newPos.getY(), new OffsetBlock(newPos.getX(), newPos.getY(), newPos.getZ(), state, false));
                        block.fallDistance = 0.0f;
                        block.setDeltaMovement(0.0, 0.33f, 0.0);
                        level.addFreshEntity((Entity)block);
                    }
                }
                ++this.radius;
                if (this.radius == 9) {
                    Scheduler.removeTask(this);
                }
            }
        });
    }

    private void charge(Ravager ravager, Player player) {
        BlockPos dist = player.getOnPos().subtract((Vec3i)ravager.getOnPos());
        double unit = Math.sqrt(dist.distSqr((Vec3i)BlockPos.ZERO));
        BlockPos move = BlockPos.containing((double)((double)dist.getX() / unit * 3.0), (double)0.0, (double)((double)dist.getZ() / unit * 3.0));
        ravager.setDeltaMovement((double)move.getX(), 0.0, (double)move.getZ());
    }

    @Override
    public void onBossFightEnd(ServerLevel level, BlockPos pos, Player player) {
        this.armorStandEntity.remove(Entity.RemovalReason.DISCARDED);
    }

    public boolean withinDistance(BlockPos pos, double rad) {
        double dist = pos.distToLowCornerSqr(0.0, 0.0, 0.0);
        return dist < rad * rad && dist >= (rad - 1.0) * (rad - 1.0);
    }
}

