/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.defaultRewards;

import chanceCubes.CCubesCore;
import chanceCubes.mcwrapper.ComponentWrapper;
import chanceCubes.mcwrapper.EntityWrapper;
import chanceCubes.rewards.defaultRewards.BossBaseReward;
import chanceCubes.util.RewardsUtil;
import chanceCubes.util.Scheduler;
import chanceCubes.util.Task;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class BossWitchReward
extends BossBaseReward {
    private final List<String> entities = Arrays.asList("creeper", "skeleton", "blaze", "enderman", "endermite", "zombie_pigman", "silverfish", "slime", "spider", "zombie");

    public BossWitchReward() {
        super("evil_witch");
    }

    @Override
    public LivingEntity initBoss(final ServerLevel level, BlockPos pos, final Player player, JsonObject settings, final BossBaseReward.BattleWrapper battleWrapper) {
        final Witch witch = (Witch)EntityType.WITCH.create((Level)level);
        witch.setCustomName((Component)ComponentWrapper.string("Evil Witch"));
        ItemStack stack = new ItemStack((ItemLike)Items.LEATHER_HELMET);
        stack.enchant(level.holderOrThrow(Enchantments.BLAST_PROTECTION), 5);
        witch.setItemSlot(EquipmentSlot.HEAD, stack);
        witch.setDropChance(EquipmentSlot.HEAD, 0.0f);
        stack = new ItemStack((ItemLike)Items.LEATHER_CHESTPLATE);
        stack.enchant(level.holderOrThrow(Enchantments.BLAST_PROTECTION), 5);
        witch.setItemSlot(EquipmentSlot.CHEST, stack);
        witch.setDropChance(EquipmentSlot.CHEST, 0.0f);
        stack = new ItemStack((ItemLike)Items.LEATHER_LEGGINGS);
        stack.enchant(level.holderOrThrow(Enchantments.BLAST_PROTECTION), 5);
        witch.setItemSlot(EquipmentSlot.LEGS, stack);
        witch.setDropChance(EquipmentSlot.LEGS, 0.0f);
        stack = new ItemStack((ItemLike)Items.LEATHER_BOOTS);
        stack.enchant(level.holderOrThrow(Enchantments.BLAST_PROTECTION), 5);
        witch.setItemSlot(EquipmentSlot.FEET, stack);
        witch.setDropChance(EquipmentSlot.FEET, 0.0f);
        this.spawnMinoins(pos, level, battleWrapper);
        Scheduler.scheduleTask(new Task("witch_abilities", -1, 20){

            @Override
            public void callback() {
            }

            @Override
            public void update() {
                if (!witch.isAlive()) {
                    Scheduler.removeTask(this);
                    return;
                }
                if (RewardsUtil.rand.nextInt(15) == 4) {
                    BossWitchReward.this.spawnMinoins(witch.getOnPos(), level, battleWrapper);
                }
                if (RewardsUtil.rand.nextInt(10) == 4) {
                    EntityWrapper.spawnLightning((Level)level, player.getOnPos());
                }
                if (RewardsUtil.rand.nextInt(5) == 4) {
                    BossWitchReward.this.throwPotion(witch, player.getOnPos(), level);
                }
            }
        });
        return witch;
    }

    private void throwPotion(Witch witch, BlockPos playerPos, ServerLevel level) {
        ThrownPotion pot = new ThrownPotion((Level)level, (LivingEntity)witch);
        MobEffectInstance potionEffect = RewardsUtil.getRandomPotionEffectInstance();
        ItemStack stack = new ItemStack((ItemLike)Items.SPLASH_POTION);
        stack.set(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY.withEffectAdded(potionEffect));
        pot.setItem(stack);
        double d0 = (double)playerPos.getY() + 0.5;
        double d1 = (double)playerPos.getX() - witch.getX();
        double d2 = d0 - pot.getY();
        double d3 = (double)playerPos.getZ() - witch.getZ();
        float f = (float)(Math.sqrt(d1 * d1 + d3 * d3) * (double)0.2f);
        pot.shoot(d1, d2 + (double)f, d3, 1.6f, 12.0f);
        level.addFreshEntity((Entity)pot);
    }

    private void spawnMinoins(BlockPos pos, ServerLevel level, BossBaseReward.BattleWrapper battleWrapper) {
        for (Direction facing : Direction.values()) {
            if (facing == Direction.UP || facing == Direction.DOWN) continue;
            try {
                Optional entType = EntityType.byString((String)this.entities.get(RewardsUtil.rand.nextInt(this.entities.size())));
                Entity ent = entType.isPresent() ? ((EntityType)entType.get()).create((Level)level) : EntityType.CREEPER.create((Level)level);
                BlockPos adjPos = pos.relative(facing, 1);
                ent.moveTo((double)adjPos.getX(), (double)adjPos.getY(), (double)adjPos.getZ());
                level.addFreshEntity(ent);
                this.trackSubEntities(battleWrapper, ent);
            }
            catch (Exception e) {
                CCubesCore.logger.log(org.apache.logging.log4j.Level.ERROR, "Uh oh! Something went wrong and the minions could not be spawned! Please report this to the mod dev!");
                return;
            }
        }
    }

    @Override
    public void onBossFightEnd(ServerLevel world, BlockPos pos, Player player) {
    }
}

