/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.defaultRewards;

import chanceCubes.rewards.defaultRewards.BaseCustomReward;
import chanceCubes.rewards.rewardparts.OffsetBlock;
import chanceCubes.util.RewardsUtil;
import com.google.gson.JsonObject;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class DoubleRainbow
extends BaseCustomReward {
    private static final Block[] colors = new Block[]{Blocks.RED_WOOL, Blocks.ORANGE_WOOL, Blocks.YELLOW_WOOL, Blocks.GREEN_WOOL, Blocks.BLUE_WOOL, Blocks.PURPLE_WOOL};

    public DoubleRainbow() {
        super("chancecubes:double_rainbow", 15);
    }

    @Override
    public void trigger(ServerLevel level, BlockPos pos, Player player, JsonObject settings) {
        OffsetBlock b;
        Block wool;
        int distIndex;
        float dist;
        int y;
        int x;
        RewardsUtil.sendMessageToNearPlayers((Level)level, pos, 32, "Double Rainbow!");
        for (x = -7; x < 8; ++x) {
            for (y = 0; y < 8; ++y) {
                dist = (float)Math.sqrt(Math.abs(pos.distToLowCornerSqr((double)(pos.getX() + x), (double)(pos.getY() + y), (double)pos.getZ())));
                if (!(dist > 1.0f) || !(dist <= 8.0f)) continue;
                distIndex = (int)(dist - 2.0f);
                wool = colors[distIndex];
                b = new OffsetBlock(x, y, 0, wool, false);
                b.setDelay((x + 7) * 10);
                b.spawnInWorld((Level)level, pos.getX(), pos.getY(), pos.getZ());
            }
        }
        for (x = -17; x < 18; ++x) {
            for (y = 0; y < 18; ++y) {
                dist = (float)Math.sqrt(Math.abs(pos.distToLowCornerSqr((double)(pos.getX() + x), (double)(pos.getY() + y), (double)pos.getZ())));
                if (!(dist >= 12.0f) || !(dist <= 18.0f)) continue;
                distIndex = (int)(dist - 12.0f);
                wool = colors[distIndex];
                b = new OffsetBlock(x, y, 0, wool, false);
                b.setDelay((x + 12) * 5);
                b.spawnInWorld((Level)level, pos.getX(), pos.getY(), pos.getZ());
            }
        }
    }
}

