/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.defaultRewards;

import chanceCubes.rewards.defaultRewards.BaseCustomReward;
import chanceCubes.util.RewardsUtil;
import chanceCubes.util.Scheduler;
import chanceCubes.util.Task;
import com.google.gson.JsonObject;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;

public class HerobrineReward
extends BaseCustomReward {
    private final String[] leaveSayings = new String[]{"I will be back for you.", "Another day, another time.", "No, you are not ready for my wrath.", "Perhaps tomorrow you will be worthy of my challenge", "I sense that I am needed else where. You escape..... For now....", "If only you were worth my time."};
    private final String[] staySayings = new String[]{"Today is the day.", "May the other world have mercy on your soul.", "MUWAHAHAHAHAHAHAH", "Time to feast!!", "How fast can your run boy!", "It's a shame this will end so quickly for you.", "My presence alone will be your end"};

    public HerobrineReward() {
        super("chancecubes:herobrine", -65);
    }

    @Override
    public void trigger(final ServerLevel world, final BlockPos pos, final Player player, JsonObject settings) {
        int realChance = super.getSettingAsInt(settings, "isReal", 20, 0, 100);
        final boolean real = RewardsUtil.rand.nextInt(100) < realChance;
        Scheduler.scheduleTask(new Task("Herobrine Reward", 280, 40){
            int stage;
            {
                super(name, delay, updateTick);
                this.stage = 0;
            }

            @Override
            public void callback() {
                RewardsUtil.sendMessageToAllPlayers((Level)world, "<Herobrine> I've changed My Mind!");
                HerobrineReward.this.spawnHerobrine(world, pos, player);
            }

            @Override
            public void update() {
                switch (this.stage) {
                    case 0: {
                        RewardsUtil.sendMessageToAllPlayers((Level)world, String.valueOf(ChatFormatting.YELLOW) + "Herobrine joined the game.");
                        break;
                    }
                    case 1: {
                        if (real) {
                            RewardsUtil.sendMessageToAllPlayers((Level)world, "<Herobrine> " + HerobrineReward.this.staySayings[RewardsUtil.rand.nextInt(HerobrineReward.this.staySayings.length)]);
                            break;
                        }
                        RewardsUtil.sendMessageToAllPlayers((Level)world, "<Herobrine> " + HerobrineReward.this.leaveSayings[RewardsUtil.rand.nextInt(HerobrineReward.this.leaveSayings.length)]);
                        break;
                    }
                    case 2: {
                        if (real) {
                            HerobrineReward.this.spawnHerobrine(world, pos, player);
                            Scheduler.removeTask(this);
                            break;
                        }
                        RewardsUtil.sendMessageToAllPlayers((Level)world, String.valueOf(ChatFormatting.YELLOW) + "Herobrine left the game.");
                        if (RewardsUtil.rand.nextInt(10) == 4) break;
                        Scheduler.removeTask(this);
                    }
                }
                ++this.stage;
            }
        });
    }

    public void spawnHerobrine(final ServerLevel level, final BlockPos pos, final Player player) {
        RewardsUtil.placeBlock(Blocks.AIR.defaultBlockState(), (Level)level, pos.offset(0, 1, 0));
        RewardsUtil.executeCommand(level, player, (Vec3i)pos, "/summon zombie ~ ~ ~ {Glowing:1b,CustomNameVisible:1b,Health:500f,IsBaby:0b,CanBreakDoors:1b,CustomName:'{\"text\":\"Herobrine\",\"color\":\"white\",\"bold\":true}',HandItems:[{id:\"minecraft:diamond_sword\",Count:1b,tag:{display:{Name:'{\"text\":\"Wrath of Herobrine\",\"color\":\"white\"}'},Unbreakable:1b,Enchantments:[{id:\"minecraft:sharpness\",lvl:5s}]}},{}],HandDropChances:[1.000F,0.085F],ArmorItems:[{id:\"minecraft:diamond_boots\",Count:1b,tag:{Enchantments:[{id:\"minecraft:protection\",lvl:5s}]}},{id:\"minecraft:diamond_leggings\",Count:1b,tag:{Enchantments:[{id:\"minecraft:protection\",lvl:5s}]}},{id:\"minecraft:diamond_chestplate\",Count:1b,tag:{Enchantments:[{id:\"minecraft:protection\",lvl:5s}]}},{id:\"minecraft:diamond_helmet\",Count:1b,tag:{Enchantments:[{id:\"minecraft:protection\",lvl:5s}]}}],ArmorDropChances:[0.000F,0.000F,0.000F,9.000F],Attributes:[{Name:generic.max_health,Base:500},{Name:generic.follow_range,Base:500},{Name:generic.knockback_resistance,Base:10},{Name:zombie.spawn_reinforcements,Base:0}]}");
        Scheduler.scheduleTask(new Task(this, "Herobrine Reward Delayed Advancement", 1){

            @Override
            public void callback() {
                RewardsUtil.executeCommand(level, player, (Vec3i)pos, "/advancement grant @p only chancecubes:herobrine");
            }
        });
    }
}

