/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.defaultRewards;

import chanceCubes.rewards.defaultRewards.BaseCustomReward;
import chanceCubes.util.CCubesDamageTypes;
import chanceCubes.util.GuiTextLocation;
import chanceCubes.util.RewardBlockCache;
import chanceCubes.util.RewardsUtil;
import chanceCubes.util.Scheduler;
import chanceCubes.util.Task;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.ServerChatEvent;

public class MathReward
extends BaseCustomReward {
    private final Map<Player, RewardInfo> inQuestion = new HashMap<Player, RewardInfo>();

    public MathReward() {
        super("chancecubes:math", -30);
    }

    @Override
    public void trigger(ServerLevel level, BlockPos pos, final Player player, JsonObject settings) {
        if (this.inQuestion.containsKey(player)) {
            return;
        }
        int num1 = RewardsUtil.rand.nextInt(100);
        int num2 = RewardsUtil.rand.nextInt(100);
        RewardsUtil.sendMessageToPlayer(player, "Quick, what's " + num1 + "+" + num2 + "?");
        BlockPos playerPos = BlockPos.containing((double)player.getX(), (double)player.getY(), (double)player.getZ());
        RewardBlockCache cache = new RewardBlockCache((Level)level, playerPos, player.getOnPos());
        for (int xx = -2; xx < 3; ++xx) {
            for (int zz = -2; zz < 3; ++zz) {
                for (int yy = 1; yy < 5; ++yy) {
                    if (xx == -2 || xx == 2 || zz == -2 || zz == 2 || yy == 1 || yy == 4) {
                        cache.cacheBlock(new BlockPos(xx, yy, zz), Blocks.BEDROCK.defaultBlockState());
                        continue;
                    }
                    if (xx != -1 && xx != 1 || zz != -1 && zz != 1 || yy != 2) continue;
                    cache.cacheBlock(new BlockPos(xx, yy, zz), Blocks.GLOWSTONE.defaultBlockState());
                }
            }
        }
        player.moveTo((double)((int)player.getX()), (double)((int)player.getY() + 2), (double)((int)player.getZ()));
        ArrayList<Entity> tnt = new ArrayList<Entity>();
        for (int i = 0; i < 5; ++i) {
            PrimedTnt entitytntprimed = new PrimedTnt((Level)level, player.getX(), player.getY() + 1.0, player.getZ(), (LivingEntity)player);
            level.addFreshEntity((Entity)entitytntprimed);
            level.playSound(player, player.getX(), player.getY(), player.getZ(), SoundEvents.TNT_PRIMED, SoundSource.BLOCKS, 1.0f, 1.0f);
            entitytntprimed.setFuse(140);
            tnt.add((Entity)entitytntprimed);
        }
        this.inQuestion.put(player, new RewardInfo(num1 + num2, tnt, cache));
        int duration = super.getSettingAsInt(settings, "answerDuration", 100, 20, 2400);
        Scheduler.scheduleTask(new Task("Math", duration, 20){

            @Override
            public void callback() {
                MathReward.this.timeUp(player, false);
            }

            @Override
            public void update() {
                if (this.delayLeft % 20 == 0) {
                    this.showTimeLeft(player, GuiTextLocation.ACTION_BAR);
                }
            }
        });
    }

    private void timeUp(Player player, boolean correct) {
        if (!this.inQuestion.containsKey(player)) {
            return;
        }
        if (!RewardsUtil.isPlayerOnline(player)) {
            return;
        }
        RewardInfo info = this.inQuestion.get(player);
        if (correct) {
            RewardsUtil.sendMessageToPlayer(player, "Correct!");
            RewardsUtil.sendMessageToPlayer(player, "Here, have a item!");
            player.level().addFreshEntity((Entity)new ItemEntity(player.level(), player.getX(), player.getY(), player.getZ(), new ItemStack((ItemLike)RewardsUtil.getRandomItem(), 1)));
        } else {
            player.level().explode((Entity)player, player.getX(), player.getY(), player.getZ(), 1.0f, Level.ExplosionInteraction.NONE);
            player.hurt(player.damageSources().source(CCubesDamageTypes.MATH_FAIL), Float.MAX_VALUE);
        }
        for (Entity tnt : info.tnt) {
            tnt.remove(Entity.RemovalReason.DISCARDED);
        }
        info.cache.restoreBlocks((Entity)player);
        this.inQuestion.remove(player);
    }

    @SubscribeEvent
    public void onMessage(ServerChatEvent event) {
        ServerPlayer player = event.getPlayer();
        if (this.inQuestion.containsKey(player)) {
            int answer = 0;
            try {
                answer = Integer.parseInt(event.getRawText());
            }
            catch (NumberFormatException e) {
                RewardsUtil.sendMessageToPlayer((Player)player, "Incorrect!");
            }
            if (this.inQuestion.get((Object)player).answer == answer) {
                this.timeUp((Player)player, true);
            } else {
                RewardsUtil.sendMessageToPlayer((Player)player, "Incorrect!");
            }
            event.setCanceled(true);
        }
    }

    private record RewardInfo(int answer, List<Entity> tnt, RewardBlockCache cache) {
    }
}

