/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.giantRewards;

import chanceCubes.rewards.defaultRewards.BaseCustomReward;
import chanceCubes.rewards.rewardparts.OffsetBlock;
import chanceCubes.util.RewardsUtil;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class BeaconArenaReward
extends BaseCustomReward {
    private final BlockState[] whitelist = new BlockState[]{Blocks.OBSIDIAN.defaultBlockState(), Blocks.DIRT.defaultBlockState(), Blocks.STONE.defaultBlockState(), Blocks.MELON.defaultBlockState(), Blocks.BOOKSHELF.defaultBlockState(), Blocks.CLAY.defaultBlockState(), RewardsUtil.getRandomWool(), Blocks.BRICKS.defaultBlockState(), Blocks.COBWEB.defaultBlockState(), Blocks.GLOWSTONE.defaultBlockState(), Blocks.NETHERRACK.defaultBlockState()};

    public BeaconArenaReward() {
        super("chancecubes:beacon_arena", 0);
    }

    @Override
    public void trigger(ServerLevel level, BlockPos pos, Player player, JsonObject settings) {
        ArrayList<OffsetBlock> blocks = new ArrayList<OffsetBlock>();
        this.spawnWall(blocks);
        this.spawnSmallBeacon(blocks, new BlockPos(17, 0, 17), Blocks.GOLD_BLOCK);
        this.spawnSmallBeacon(blocks, new BlockPos(-17, 0, 17), Blocks.DIAMOND_BLOCK);
        this.spawnSmallBeacon(blocks, new BlockPos(-17, 0, -17), Blocks.EMERALD_BLOCK);
        this.spawnSmallBeacon(blocks, new BlockPos(17, 0, -17), Blocks.IRON_BLOCK);
        this.spawnBigBeacon(blocks);
        this.editFloor(blocks);
        for (OffsetBlock b : blocks) {
            b.spawnInWorld((Level)level, pos.getX(), pos.getY() - 1, pos.getZ());
        }
    }

    public void spawnSmallBeacon(List<OffsetBlock> blocks, BlockPos at, Block b) {
        int delay = 0;
        for (int x = -1; x < 2; ++x) {
            for (int z = -1; z < 2; ++z) {
                blocks.add(new OffsetBlock(at.getX() + x, at.getY(), at.getZ() + z, b, false, delay));
                ++delay;
            }
        }
        blocks.add(new OffsetBlock(at.getX(), at.getY() + 1, at.getZ(), Blocks.BEACON, false, delay).setCausesBlockUpdate(true));
    }

    public void spawnBigBeacon(List<OffsetBlock> blocks) {
        int delay = 0;
        for (int y = 0; y < 2; ++y) {
            for (int x = -2; x < 3; ++x) {
                for (int z = -2; z < 3; ++z) {
                    if (y == 1 && (x <= -2 || x >= 2 || z <= -2 || z >= 2)) continue;
                    blocks.add(new OffsetBlock(x, y, z, Blocks.IRON_BLOCK, false, delay));
                    ++delay;
                }
            }
        }
        blocks.add(new OffsetBlock(0, 2, 0, Blocks.BEACON, false, delay).setCausesBlockUpdate(true));
    }

    public void spawnWall(List<OffsetBlock> blocks) {
        ArrayList<BlockPos> usedPositions = new ArrayList<BlockPos>();
        for (int degree = 0; degree < 360; ++degree) {
            int z;
            double arcVal = Math.toRadians(degree);
            int x = (int)(28.0 * Math.cos(arcVal));
            BlockPos temp = new BlockPos(x, 0, z = (int)(28.0 * Math.sin(arcVal)));
            if (usedPositions.contains(temp)) continue;
            usedPositions.add(temp);
        }
        int delay = 0;
        for (BlockPos pos : usedPositions) {
            blocks.add(new OffsetBlock(pos.getX(), pos.getY(), pos.getZ(), Blocks.GLASS, false, delay));
            blocks.add(new OffsetBlock(pos.getX(), pos.getY() + 1, pos.getZ(), Blocks.GLASS, false, delay + 1));
            blocks.add(new OffsetBlock(pos.getX(), pos.getY() + 2, pos.getZ(), Blocks.GLASS, false, delay + 2));
            ++delay;
        }
    }

    public void editFloor(List<OffsetBlock> blocks) {
        int delay = 0;
        ArrayList<BlockPos> usedPositions = new ArrayList<BlockPos>();
        for (int radius = 0; radius < 28; ++radius) {
            for (int degree = 0; degree < 360; ++degree) {
                int z;
                double arcVal = Math.toRadians(degree);
                int x = (int)((double)radius * Math.cos(arcVal));
                BlockPos temp = new BlockPos(x, 0, z = (int)((double)radius * Math.sin(arcVal)));
                if (usedPositions.contains(temp)) continue;
                usedPositions.add(temp);
            }
        }
        for (BlockPos pos : usedPositions) {
            BlockState state = this.whitelist[RewardsUtil.rand.nextInt(this.whitelist.length)];
            blocks.add(new OffsetBlock(pos.getX(), -1, pos.getZ(), state, false, delay / 8));
            ++delay;
        }
    }
}

