/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.giantRewards;

import chanceCubes.config.CCubesSettings;
import chanceCubes.rewards.defaultRewards.BaseCustomReward;
import chanceCubes.util.RewardsUtil;
import chanceCubes.util.Scheduler;
import chanceCubes.util.Task;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class BlockThrowerReward
extends BaseCustomReward {
    public BlockThrowerReward() {
        super("chancecubes:block_thrower", 0);
    }

    @Override
    public void trigger(final ServerLevel level, final BlockPos pos, Player player, JsonObject settings) {
        for (int x = -20; x < 21; ++x) {
            for (int z = -20; z < 21; ++z) {
                if (level.getBlockState(pos.offset(x, 11, z)).isAir()) continue;
                for (int y = -1; y < 12; ++y) {
                    level.setBlockAndUpdate(pos.offset(x, y, z), Blocks.AIR.defaultBlockState());
                }
            }
        }
        Scheduler.scheduleTask(new Task(this, "Throw_Block", 450, 2){
            private final List<FallingBlockEntity> blocks;
            {
                super(name, delay, updateTick);
                this.blocks = new ArrayList<FallingBlockEntity>();
            }

            @Override
            public void update() {
                if (this.delayLeft > 100) {
                    int y;
                    int x = RewardsUtil.rand.nextInt(41) - 21;
                    int z = RewardsUtil.rand.nextInt(41) - 21;
                    for (y = 12; y > -2 && level.getBlockState(pos.offset(x, y, z)).isAir(); --y) {
                    }
                    BlockPos newPos = pos.offset(x, y, z);
                    BlockState state = level.getBlockState(newPos);
                    if (CCubesSettings.nonReplaceableBlocks.contains(state) || state.getBlock().equals(Blocks.AIR)) {
                        state = Blocks.DIRT.defaultBlockState();
                    } else {
                        level.setBlockAndUpdate(newPos, Blocks.AIR.defaultBlockState());
                    }
                    FallingBlockEntity block = FallingBlockEntity.fall((Level)level, (BlockPos)BlockPos.containing((double)((double)newPos.getX() + 0.5), (double)newPos.getY(), (double)((double)newPos.getZ() + 0.5)), (BlockState)state);
                    block.fallDistance = 0.0f;
                    block.setNoGravity(true);
                    block.setDeltaMovement(0.0, 0.25, 0.0);
                    level.addFreshEntity((Entity)block);
                    this.blocks.add(block);
                }
                for (FallingBlockEntity b : this.blocks) {
                    if (!(b.getY() > (double)(pos.getY() + 8))) continue;
                    b.moveTo(b.getX(), (double)(pos.getY() + 8), b.getZ());
                    b.setDeltaMovement(0.0, 0.0, 0.0);
                }
            }

            @Override
            public void callback() {
                int rand = RewardsUtil.rand.nextInt(6);
                for (FallingBlockEntity b : this.blocks) {
                    Entity ent;
                    level.addParticle((ParticleOptions)ParticleTypes.EXPLOSION, b.getX(), b.getY(), b.getZ(), 0.0, 0.0, 0.0);
                    b.remove(Entity.RemovalReason.DISCARDED);
                    if (rand == 0) {
                        ent = EntityType.CREEPER.create((Level)level);
                        ((LivingEntity)ent).addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 20, 3));
                    } else if (rand == 1) {
                        ent = EntityType.TNT.create((Level)level);
                    } else if (rand == 2) {
                        ent = EntityType.ITEM.create((Level)level);
                        ((ItemEntity)ent).setItem(new ItemStack((ItemLike)Items.DIAMOND));
                    } else if (rand == 3) {
                        ent = EntityType.ITEM.create((Level)level);
                        ((ItemEntity)ent).setItem(new ItemStack((ItemLike)Items.MELON_SLICE));
                    } else if (rand == 4) {
                        ent = EntityType.BAT.create((Level)level);
                    } else {
                        ent = EntityType.ZOMBIE.create((Level)level);
                        ((LivingEntity)ent).addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 20, 3));
                    }
                    ent.moveTo(b.getX(), b.getY(), b.getZ());
                    level.addFreshEntity(ent);
                }
                level.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (Holder)SoundEvents.GENERIC_EXPLODE, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        });
    }
}

