/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.giantRewards;

import chanceCubes.rewards.defaultRewards.BaseCustomReward;
import chanceCubes.util.RewardsUtil;
import chanceCubes.util.Scheduler;
import chanceCubes.util.Task;
import com.google.gson.JsonObject;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.level.Level;

public class FireworkShowReward
extends BaseCustomReward {
    public FireworkShowReward() {
        super("chancecubes:firework_show", 0);
    }

    @Override
    public void trigger(ServerLevel level, BlockPos pos, Player player, JsonObject settings) {
        RewardsUtil.executeCommand(level, player, (Vec3i)pos, "/time set 15000");
        this.stage1(level, pos, player);
    }

    public void stage1(final ServerLevel level, final BlockPos pos, final Player player) {
        Scheduler.scheduleTask(new Task("Firework_Show_Task_Stage_1", 200, 5){
            double angle;
            {
                super(name, delay, updateTick);
                this.angle = 0.0;
            }

            @Override
            public void callback() {
                FireworkShowReward.this.stage2(level, pos, player);
            }

            @Override
            public void update() {
                this.angle += 0.5;
                FireworkShowReward.this.spawnFirework(level, (double)pos.getX() + this.angle / 3.0 * Math.cos(this.angle), pos.getY(), (double)pos.getZ() + this.angle / 3.0 * Math.sin(this.angle));
                FireworkShowReward.this.spawnFirework(level, (double)pos.getX() + this.angle / 3.0 * Math.cos(this.angle + Math.PI), pos.getY(), (double)pos.getZ() + this.angle / 3.0 * Math.sin(this.angle + Math.PI));
            }
        });
    }

    public void stage2(final ServerLevel level, final BlockPos pos, final Player player) {
        Scheduler.scheduleTask(new Task("Firework_Show_Task_Stage_2", 200, 5){
            double tick;
            {
                super(name, delay, updateTick);
                this.tick = 0.0;
            }

            @Override
            public void callback() {
                FireworkShowReward.this.stage3(level, pos, player);
            }

            @Override
            public void update() {
                this.tick += 0.5;
                FireworkShowReward.this.spawnFirework(level, (double)pos.getX() + (this.tick - 20.0), pos.getY(), pos.getZ() + 1);
                FireworkShowReward.this.spawnFirework(level, (double)pos.getX() + (20.0 - this.tick), pos.getY(), pos.getZ() - 1);
            }
        });
    }

    public void stage3(final ServerLevel level, final BlockPos pos, Player player) {
        Scheduler.scheduleTask(new Task("Firework_Show_Task_Stage_2", 200, 3){

            @Override
            public void callback() {
            }

            @Override
            public void update() {
                FireworkShowReward.this.spawnFirework(level, pos.getX() + (RewardsUtil.rand.nextInt(10) - 5), pos.getY(), pos.getZ() + (RewardsUtil.rand.nextInt(10) - 5));
            }
        });
    }

    public void spawnFirework(ServerLevel level, double x, double y, double z) {
        level.addFreshEntity((Entity)new FireworkRocketEntity((Level)level, x, y, z, RewardsUtil.getRandomFirework((HolderLookup.Provider)level.registryAccess())));
    }
}

