/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.variableTypes;

import chanceCubes.CCubesCore;
import chanceCubes.rewards.variableParts.ListPart;
import chanceCubes.rewards.variableParts.RandomPart;
import chanceCubes.rewards.variableParts.StringPart;
import chanceCubes.rewards.variableTypes.CustomVar;
import org.apache.logging.log4j.Level;

public class FloatVar
extends CustomVar {
    public FloatVar() {
    }

    public FloatVar(float val) {
        super.addPart(new StringPart(val));
    }

    public FloatVar(Float[] val) {
        this.addPart(new ListPart<Float>(val));
    }

    public float getFloatValue() {
        String val = super.getValue();
        if (FloatVar.isFloat(val)) {
            return Float.parseFloat(val);
        }
        CCubesCore.logger.log(Level.ERROR, "An Error occurred while processing a Reward value! " + val + " is not a float!");
        return 0.0f;
    }

    public static RandomPart<Float> parseRandom(String input) {
        if ((input = input.replaceAll(" ", "")).charAt(3) == '(' && input.indexOf(41, 3) != -1) {
            String[] randParams = input.substring(4, input.lastIndexOf(41)).split(",");
            if (randParams.length == 1 && FloatVar.isFloat(randParams[0])) {
                return new RandomPart<Float>(Float.valueOf(0.0f), Float.valueOf(Float.parseFloat(randParams[0])));
            }
            if (randParams.length == 2 && FloatVar.isFloat(randParams[0]) && FloatVar.isFloat(randParams[1])) {
                return new RandomPart<Float>(Float.valueOf(Float.parseFloat(randParams[0])), Float.valueOf(Float.parseFloat(randParams[1])));
            }
        }
        return new RandomPart<Float>(Float.valueOf(0.0f), Float.valueOf(1.0f));
    }

    public static boolean isFloat(String input) {
        return input.matches("[-+]?\\d*\\.?\\d+");
    }
}

