/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.clavis.common.client.screen;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.architectury.networking.NetworkManager;
import dev.architectury.platform.Platform;
import it.hurts.octostudios.octolib.client.animation.Tween;
import it.hurts.octostudios.octolib.client.particle.UIParticle;
import it.hurts.octostudios.octolib.util.RenderUtils;
import it.hurts.shatterbyte.clavis.common.Clavis;
import it.hurts.shatterbyte.clavis.common.ClavisClient;
import it.hurts.shatterbyte.clavis.common.client.particle.HalfHeartUIParticle;
import it.hurts.shatterbyte.clavis.common.client.particle.HeartPartUIParticle;
import it.hurts.shatterbyte.clavis.common.client.screen.widget.AbstractMinigameWidget;
import it.hurts.shatterbyte.clavis.common.client.screen.widget.MinigameInfoWidget;
import it.hurts.shatterbyte.clavis.common.client.screen.widget.RuleWidget;
import it.hurts.shatterbyte.clavis.common.data.Lock;
import it.hurts.shatterbyte.clavis.common.data.MinigameStyleData;
import it.hurts.shatterbyte.clavis.common.data.TooltipInfoData;
import it.hurts.shatterbyte.clavis.common.minigame.Minigame;
import it.hurts.shatterbyte.clavis.common.minigame.rule.Rule;
import it.hurts.shatterbyte.clavis.common.network.packet.FinishLockpickingPacket;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.texture.Tickable;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.Level;

public class LockpickingScreen<T extends AbstractMinigameWidget<?>>
extends Screen {
    public static final ResourceLocation EMPTY_HEART = Clavis.path("textures/lockpicking/empty_heart.png");
    public static final ResourceLocation HEART = Clavis.path("textures/lockpicking/heart.png");
    private final Supplier<T> widgetFactory;
    Minigame<T> game;
    T minigameWidget;
    BlockPos blockPos;
    Lock lock;
    MinigameStyleData styleData;

    public LockpickingScreen(BlockPos blockPos, Lock lock, Supplier<T> widgetFactory) {
        super((Component)Component.empty());
        this.blockPos = blockPos;
        this.lock = lock;
        this.widgetFactory = widgetFactory;
        Tween tween = Tween.create().setLoops(-1);
        tween.tweenRunnable(() -> Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.WOODEN_BUTTON_CLICK_ON, (float)2.0f)));
        tween.tweenInterval(0.5);
        tween.tweenRunnable(() -> Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.WOODEN_BUTTON_CLICK_OFF, (float)1.6f)));
        tween.tweenInterval(0.5);
        tween.tweenRunnable(() -> Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.WOODEN_BUTTON_CLICK_OFF, (float)1.6f)));
        tween.tweenInterval(0.5);
        tween.tweenRunnable(() -> Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.WOODEN_BUTTON_CLICK_OFF, (float)1.6f)));
        tween.tweenInterval(0.5);
        tween.tweenRunnable(() -> {
            if (Minecraft.getInstance().screen != this) {
                tween.kill();
            }
        });
    }

    public void tick() {
        this.children().forEach(child -> {
            if (child instanceof Tickable) {
                Tickable tickable = (Tickable)child;
                tickable.tick();
            }
        });
        this.game.processOnTickRules();
        if (Minecraft.getInstance().player != null && Minecraft.getInstance().player.position().distanceToSqr(this.blockPos.getCenter()) > 256.0) {
            Minecraft.getInstance().setScreen(null);
        }
    }

    public void finish(boolean hasLostTheGame) {
        ClavisClient.SCREEN_CACHE.remove(this.lock);
        NetworkManager.sendToServer((CustomPacketPayload)new FinishLockpickingPacket(this.blockPos, this.lock, this.game.getLootQuality(), hasLostTheGame));
        Minecraft.getInstance().setScreen(null);
    }

    protected void init() {
        this.addOrRepositionWidget((AbstractMinigameWidget)((Object)this.widgetFactory.get()));
    }

    private void addOrRepositionWidget(T genericWidget) {
        if (this.minigameWidget == null) {
            this.minigameWidget = genericWidget;
            this.game = new Minigame<T>(this.minigameWidget);
            ((AbstractMinigameWidget)((Object)this.minigameWidget)).setMinigame(this.game);
            this.game.load(this.lock, (Level)Minecraft.getInstance().level);
            ((AbstractMinigameWidget)((Object)this.minigameWidget)).processDifficulty(this.game);
            if (this.game.getRules().isEmpty()) {
                int ruleNumber = (int)Math.min(Math.ceil(this.game.getDifficulty() / 0.33f), 3.0);
                List rules = Lists.newArrayList(Rule.getRegisteredRules(this.minigameWidget.getClass()));
                Collections.shuffle(rules, ((AbstractMinigameWidget)((Object)this.minigameWidget)).getRandom());
                rules = rules.stream().limit(ruleNumber).toList();
                this.game.addRules(rules);
            }
            this.game.processOnCreateRules();
        }
        this.minigameWidget.setPosition(Math.round((float)this.width / 2.0f - (float)this.minigameWidget.getWidth() + 8.0f), Math.round((float)this.height / 2.0f - (float)this.minigameWidget.getHeight() / 2.0f - 8.0f));
        int x = Math.round((float)this.width / 2.0f) + 20;
        int y = Math.round((float)this.height / 2.0f - (float)this.minigameWidget.getHeight() / 2.0f) - 8;
        this.styleData = MinigameStyleData.get(this.game.getMinigameType());
        for (Rule<T> rule : this.game.getRules()) {
            RuleWidget widget = new RuleWidget(x, y, rule, this);
            this.addRenderableWidget((GuiEventListener)widget);
            y += widget.getHeight() + 2;
        }
        MinigameInfoWidget infoWidget = new MinigameInfoWidget(this.game, this.styleData);
        infoWidget.setPosition(x, y);
        this.addRenderableWidget((GuiEventListener)infoWidget);
        this.addRenderableWidget((GuiEventListener)this.minigameWidget);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderTransparentBackground(guiGraphics);
    }

    public void animateHeart() {
        Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.AMETHYST_CLUSTER_BREAK, (float)1.5f, (float)0.8f));
        float x = (float)this.minigameWidget.getX() + (float)this.minigameWidget.getWidth() / 2.0f - 64.0f;
        float y = this.minigameWidget.getY() + this.minigameWidget.getHeight() + 16;
        int health = this.game.getHealth();
        HalfHeartUIParticle left = new HalfHeartUIParticle(false, x += (float)(health * 32), y, UIParticle.Layer.SCREEN, 1.0f);
        HalfHeartUIParticle right = new HalfHeartUIParticle(true, x, y, UIParticle.Layer.SCREEN, 1.0f);
        left.setScreen(this);
        right.setScreen(this);
        left.instantiate();
        right.instantiate();
        for (int i = 0; i < 3; ++i) {
            HeartPartUIParticle particle = new HeartPartUIParticle(x, y, UIParticle.Layer.SCREEN, 0.5f);
            particle.setScreen(this);
            particle.instantiate();
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)this.minigameWidget.getX() + (float)this.minigameWidget.getWidth() / 2.0f, (float)(this.minigameWidget.getY() + this.minigameWidget.getHeight()), 0.0f);
        guiGraphics.pose().translate(-80.0f, 8.0f, 10.0f);
        for (int i = 1; i <= 5; ++i) {
            guiGraphics.blit(i <= this.getGame().getHealth() ? HEART : EMPTY_HEART, 0, 0, 32, 32, 0.0f, 0.0f, 32, 32, 32, 32);
            guiGraphics.pose().translate(32.0f, 0.0f, 0.0f);
        }
        guiGraphics.pose().popPose();
    }

    public static void renderTooltip(ResourceLocation minigameType, Font font, TooltipInfoData tooltipInfoData, GuiGraphics guiGraphics, double mouseX, double mouseY, float partialTick, boolean isDescription) {
        List<FormattedCharSequence> toRender = isDescription ? tooltipInfoData.getDescription() : tooltipInfoData.getSummary();
        int length = isDescription ? tooltipInfoData.getDescriptionLength() : tooltipInfoData.getSummaryLength();
        length = Math.round((float)length * 0.75f) + 2;
        int height = Math.round((float)((toRender.size() - 1) * 9) * 0.75f) + 3;
        mouseX += 1.0;
        mouseY -= (double)(22 + height);
        if (mouseX + (double)length + 16.0 > (double)Minecraft.getInstance().screen.width) {
            mouseX -= (double)(18 + length);
        }
        ResourceLocation tooltip = Clavis.path(minigameType.getNamespace(), "textures/lockpicking/" + minigameType.getPath() + "/tooltip.png");
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(mouseX, mouseY, 0.0);
        guiGraphics.blit(tooltip, 0, 0, 8, 8, 0.0f, 0.0f, 8, 8, 34, 16);
        guiGraphics.blit(tooltip, 8, 0, length, 8, 8.0f, 0.0f, 1, 8, 34, 16);
        guiGraphics.blit(tooltip, 8 + length, 0, 8, 8, 9.0f, 0.0f, 8, 8, 34, 16);
        RenderUtils.renderTilingTexture((PoseStack)guiGraphics.pose(), (float)0.0f, (float)8.0f, (float)17.0f, (float)8.0f, (float)34.0f, (float)16.0f, (float)8.0f, (float)height, (float)0.0f, (boolean)true, (boolean)true);
        guiGraphics.blit(tooltip, 8, 8, length, height, 25.0f, 8.0f, 1, 8, 34, 16);
        RenderUtils.renderTilingTexture((PoseStack)guiGraphics.pose(), (float)(8 + length), (float)8.0f, (float)26.0f, (float)8.0f, (float)34.0f, (float)16.0f, (float)8.0f, (float)height, (float)0.0f, (boolean)true, (boolean)true);
        guiGraphics.blit(tooltip, 0, 8 + height, 8, 8, 0.0f, 8.0f, 8, 8, 34, 16);
        guiGraphics.blit(tooltip, 8, 8 + height, length, 8, 8.0f, 8.0f, 1, 8, 34, 16);
        guiGraphics.blit(tooltip, 8 + length, 8 + height, 8, 8, 9.0f, 8.0f, 8, 8, 34, 16);
        guiGraphics.pose().popPose();
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(mouseX + 9.0, mouseY + 8.0, 1.0);
        guiGraphics.pose().scale(0.75f, 0.75f, 1.0f);
        for (FormattedCharSequence sequence : toRender) {
            guiGraphics.drawString(font, sequence, 0, 0, -9228512, false);
            guiGraphics.pose().translate(0.0f, 9.0f, 0.0f);
        }
        guiGraphics.pose().popPose();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (Platform.isDevelopmentEnvironment() && button == 1) {
            ((AbstractMinigameWidget)((Object)this.minigameWidget)).killTweens();
            this.minigameWidget = null;
            this.rebuildWidgets();
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public Minigame<T> getGame() {
        return this.game;
    }

    public Lock getLock() {
        return this.lock;
    }

    public MinigameStyleData getStyleData() {
        return this.styleData;
    }
}

