/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.clavis.common.client.screen.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.math.Axis;
import it.hurts.octostudios.octolib.client.animation.Tween;
import it.hurts.octostudios.octolib.client.animation.easing.EaseType;
import it.hurts.octostudios.octolib.client.animation.easing.TransitionType;
import it.hurts.octostudios.octolib.client.particle.UIParticle;
import it.hurts.octostudios.octolib.client.screen.widget.Child;
import it.hurts.shatterbyte.clavis.common.Clavis;
import it.hurts.shatterbyte.clavis.common.client.particle.MeteorPartUIParticle;
import it.hurts.shatterbyte.clavis.common.client.screen.widget.FakeMeteorWidget;
import it.hurts.shatterbyte.clavis.common.client.screen.widget.MirrorWidget;
import it.hurts.shatterbyte.clavis.common.registry.SoundEventRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.texture.Tickable;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2d;
import org.joml.Vector2dc;
import org.joml.Vector2f;
import org.joml.Vector2i;

public class MeteorWidget
extends AbstractWidget
implements Child<MirrorWidget>,
Tickable {
    public ResourceLocation METEOR;
    public ResourceLocation METEOR_CRACKED;
    public ResourceLocation METEOR_HOT;
    public ResourceLocation METEOR_SHINE = Clavis.path("textures/minigame/mirror/meteor_shine.png");
    Tween scaleTween = Tween.create();
    Tween hotTween = Tween.create();
    Vector2f visualSize = new Vector2f(1.0f, 1.0f);
    boolean cracked = false;
    float heatProgress;
    float oldRot;
    float rot;
    float rotSpeed;
    float conservedMomentum = 0.975f;
    int size = 0;
    MirrorWidget parent;
    public Vector2d oldPos;
    public Vector2d precisePosition;
    Vector2d velocity = new Vector2d();

    public MeteorWidget(int x, int y, int size, MirrorWidget parent) {
        super(x, y, 11 + size * 4, 11 + size * 4, (Component)Component.empty());
        this.size = size;
        this.rotSpeed = parent.random.nextFloat(-0.05f, 0.05f);
        this.setParent(parent);
        this.precisePosition = new Vector2d((double)x, (double)y);
        this.oldPos = new Vector2d((double)x, (double)y);
        this.METEOR = Clavis.path("textures/minigame/mirror/meteor_" + size + ".png");
        this.METEOR_CRACKED = Clavis.path("textures/minigame/mirror/meteor_cracked_" + size + ".png");
        this.METEOR_HOT = Clavis.path("textures/minigame/mirror/meteor_hot_" + size + ".png");
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        Vector2i parentPos = this.getParentPosition();
        float partial = Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(false);
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)parentPos.x, (float)parentPos.y, 0.0f);
        guiGraphics.pose().translate(Mth.lerp((double)partial, (double)this.oldPos.x, (double)this.precisePosition.x), Mth.lerp((double)partial, (double)this.oldPos.y, (double)this.precisePosition.y), 0.0);
        guiGraphics.pose().translate((float)this.width / 2.0f, (float)this.height / 2.0f, 0.0f);
        guiGraphics.pose().mulPose(Axis.ZP.rotation(Mth.lerp((float)partial, (float)this.oldRot, (float)this.rot)));
        guiGraphics.pose().scale(this.visualSize.x, this.visualSize.y, 1.0f);
        guiGraphics.blit(this.cracked ? this.METEOR_CRACKED : this.METEOR, -10, -10, 19, 19, 0.0f, 0.0f, 19, 19, 19, 19);
        if ((double)this.heatProgress > 0.01 && !this.cracked) {
            RenderSystem.enableBlend();
            RenderSystem.setShaderColor((float)this.parent.gameColor.r(), (float)this.parent.gameColor.g(), (float)this.parent.gameColor.b(), (float)(this.heatProgress / (4.0f - (float)this.size)));
            guiGraphics.blit(this.METEOR_SHINE, -19, -19, 38, 38, 0.0f, 0.0f, 38, 38, 38, 38);
            RenderSystem.setShaderColor((float)this.parent.gameColor.r(), (float)this.parent.gameColor.g(), (float)this.parent.gameColor.b(), (float)this.heatProgress);
            guiGraphics.blit(this.METEOR_HOT, -10, -10, 19, 19, 0.0f, 0.0f, 19, 19, 19, 19);
            RenderSystem.setShaderColor((float)this.parent.gameColor.r(), (float)this.parent.gameColor.g(), (float)this.parent.gameColor.b(), (float)this.parent.gameColor.a());
            RenderSystem.disableBlend();
        }
        guiGraphics.pose().translate((float)(-this.width) / 2.0f, (float)(-this.height) / 2.0f, 0.0f);
        guiGraphics.pose().popPose();
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    public void playDownSound(SoundManager handler) {
        handler.play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)SoundEvents.GENERIC_EXPLODE.value()), (float)1.33f, (float)0.25f));
        handler.play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)SoundEventRegistry.METEOR_SMASH.get()), (float)0.66f, (float)1.25f));
    }

    public boolean isHot() {
        return this.heatProgress >= 0.6f;
    }

    public void makeItHot() {
        this.heatProgress = 0.0f;
        Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.BEACON_ACTIVATE, (float)1.25f));
        this.hotTween.kill();
        this.hotTween = Tween.create();
        this.hotTween.tweenInterval(0.4);
        this.hotTween.tweenRunnable(() -> Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.FIRE_AMBIENT, (float)0.85f)));
        this.hotTween.tweenMethod(this::setHeatProgress, (Object)Float.valueOf(0.0f), (Object)Float.valueOf(1.0f), 1.25).setEaseType(EaseType.EASE_IN_OUT).setTransitionType(TransitionType.QUAD);
        this.hotTween.tweenInterval(1.5);
        this.hotTween.tweenMethod(this::setHeatProgress, (Object)Float.valueOf(1.0f), (Object)Float.valueOf(0.0f), 0.8).setEaseType(EaseType.EASE_OUT).setTransitionType(TransitionType.EXPO);
        this.hotTween.start();
    }

    public void regenerate() {
        if (!this.isCracked()) {
            return;
        }
        this.hotTween.kill();
        this.heatProgress = 0.0f;
        this.scaleTween.kill();
        this.scaleTween = Tween.create();
        this.scaleTween.setTransitionType(TransitionType.QUART);
        this.scaleTween.setEase(EaseType.EASE_IN);
        this.scaleTween.tweenMethod(this::setVisualSize, (Object)new Vector2f(0.95f, 0.95f), (Object)new Vector2f(1.25f, 1.25f), (double)0.275f);
        this.scaleTween.tweenRunnable(() -> {
            this.cracked = false;
            Vector2d center = this.getCenterPos(true);
            for (int i = 0; i < 4 + this.size; ++i) {
                MeteorPartUIParticle particle = new MeteorPartUIParticle(MeteorPartUIParticle.getRandomPart(this.parent.random), 16, (float)center.x, (float)center.y, (float)this.width * 1.75f, UIParticle.Layer.SCREEN, 1.0f);
                particle.setSpeed(0.75f);
                particle.getDirection().mul(-1.0f);
                particle.setScreen(this.parent.getScreen());
                particle.instantiate();
            }
        });
        this.scaleTween.tweenMethod(this::setVisualSize, (Object)new Vector2f(1.2f, 1.2f), (Object)new Vector2f(1.0f, 1.0f), 0.25).setEaseType(EaseType.EASE_OUT);
        this.scaleTween.start();
    }

    @Nullable
    public MirrorWidget getParent() {
        return this.parent;
    }

    public void setParent(@Nullable MirrorWidget parent) {
        this.parent = parent;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isCracked()) {
            return false;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public void onClick(double mouseX, double mouseY) {
        if (this.isHot()) {
            this.parent.minigame.hurt();
            this.getParent().getMinigame().processOnClickRules(false);
            return;
        }
        this.cracked = true;
        this.hotTween.kill();
        this.heatProgress = 0.0f;
        if (this.getParent().children.stream().filter(meteor -> !(meteor instanceof FakeMeteorWidget)).allMatch(MeteorWidget::isCracked)) {
            this.getParent().playWinAnimation();
            return;
        }
        this.playCrackAnimation();
        this.getParent().getMinigame().processOnClickRules(true);
    }

    public void playCrackAnimation() {
        this.scaleTween.kill();
        this.scaleTween = Tween.create();
        this.scaleTween.setTransitionType(TransitionType.QUART);
        this.scaleTween.setEase(EaseType.EASE_OUT);
        this.scaleTween.tweenMethod(this::setVisualSize, (Object)new Vector2f(1.25f, 1.25f), (Object)new Vector2f(1.0f, 1.0f), 1.0);
        this.scaleTween.start();
        Vector2d center = this.getCenterPos(true);
        for (int i = 0; i < 4 + this.size; ++i) {
            MeteorPartUIParticle particle = new MeteorPartUIParticle(MeteorPartUIParticle.getRandomPart(this.parent.random), 30, (float)center.x, (float)center.y, this.width, UIParticle.Layer.SCREEN, 1.0f);
            particle.setScreen(this.parent.getScreen());
            particle.instantiate();
        }
    }

    public Vector2d getCenterPos(boolean global) {
        Vector2d localCenterPos = new Vector2d((Vector2dc)this.precisePosition).add((double)((float)this.width / 2.0f), (double)((float)this.height / 2.0f));
        if (!global) {
            return localCenterPos;
        }
        Vector2i parentPos = this.getParentPosition();
        return localCenterPos.add((double)parentPos.x, (double)parentPos.y);
    }

    private void collide() {
        double objCenterX = this.precisePosition.x + (double)((float)this.getWidth() / 2.0f);
        double objCenterY = this.precisePosition.y + (double)((float)this.getHeight() / 2.0f);
        double dx = objCenterX - (double)((float)this.getParent().getWidth() / 2.0f);
        double dy = objCenterY - (double)((float)this.getParent().getHeight() / 2.0f);
        float dist = (float)Math.sqrt(dx * dx + dy * dy);
        float objRadius = (float)Math.max(this.width, this.height) / 2.0f;
        objRadius += (float)Math.sqrt((float)this.width / 2.0f * ((float)this.height / 2.0f) * 2.0f);
        float radius = (float)this.getParent().getWidth() / 2.0f - 6.0f;
        if (dist + (objRadius /= 2.0f) > radius) {
            float overlap = dist + objRadius - radius;
            double normX = dx / (double)dist;
            double normY = dy / (double)dist;
            this.precisePosition.x = objCenterX -= normX * (double)overlap + (double)((float)this.getWidth() / 2.0f);
            this.precisePosition.y = objCenterY -= normY * (double)overlap + (double)((float)this.getHeight() / 2.0f);
            double prevLength = this.velocity.length();
            double dot = this.velocity.x * normX + this.velocity.y * normY;
            this.velocity.x -= 2.0 * dot * normX;
            this.velocity.y -= 2.0 * dot * normY;
            this.velocity.normalize(prevLength * (double)0.925f);
            double tangentX = this.velocity.x - normX * (this.velocity.x * normX + this.velocity.y * normY);
            double tangentY = this.velocity.y - normY * (this.velocity.x * normX + this.velocity.y * normY);
            double tangentialSpeed = Math.sqrt(tangentX * tangentX + tangentY * tangentY);
            this.rotSpeed = -this.rotSpeed;
            this.rotSpeed += (float)(tangentialSpeed * 0.01);
            this.rotSpeed = Mth.clamp((float)this.rotSpeed, (float)-0.1f, (float)0.1f);
        }
    }

    public void tick() {
        this.oldPos = new Vector2d((Vector2dc)this.precisePosition);
        this.oldRot = this.rot;
        this.rot += this.rotSpeed;
        for (MeteorWidget child : this.getParent().children()) {
            Vector2d otherPos;
            Vector2d thisPos;
            if (child == this || !((thisPos = this.getCenterPos(false)).distance((Vector2dc)(otherPos = child.getCenterPos(false))) < (double)((float)this.width * 0.9f))) continue;
            this.velocity.add((Vector2dc)thisPos.sub((Vector2dc)otherPos).normalize(0.75));
            child.velocity.sub((Vector2dc)thisPos);
        }
        if (this.velocity.lengthSquared() > 0.005) {
            this.precisePosition.x += this.velocity.x;
            this.precisePosition.y += this.velocity.y;
            this.collide();
        } else if (this.velocity.lengthSquared() != 0.0) {
            this.velocity.mul(0.0);
        }
        this.setX((int)this.precisePosition.x);
        this.setY((int)this.precisePosition.y);
        this.velocity.mul((double)this.conservedMomentum);
    }

    public void setVisualSize(Vector2f visualSize) {
        this.visualSize = visualSize;
    }

    public boolean isCracked() {
        return this.cracked;
    }

    public void setHeatProgress(float heatProgress) {
        this.heatProgress = heatProgress;
    }

    public Vector2d getVelocity() {
        return this.velocity;
    }
}

