/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.clavis.common.network.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import it.hurts.shatterbyte.clavis.common.LockManager;
import it.hurts.shatterbyte.clavis.common.data.Box;
import it.hurts.shatterbyte.clavis.common.data.Lock;
import it.hurts.shatterbyte.clavis.common.data.LootUtils;
import it.hurts.shatterbyte.clavis.common.registry.MinigameTypeRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.commands.arguments.coordinates.WorldCoordinates;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.RandomizableContainer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ClavisCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext commandBuildContext, Commands.CommandSelection commandSelection) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"clavis").requires(source -> source.hasPermission(2))).then(Commands.literal((String)"calculate").then(Commands.argument((String)"blockpos", (ArgumentType)BlockPosArgument.blockPos()).then(Commands.argument((String)"iterations", (ArgumentType)IntegerArgumentType.integer((int)0, (int)100)).executes(context -> {
            ServerLevel level = ((CommandSourceStack)context.getSource()).getLevel();
            BlockPos pos = ((WorldCoordinates)context.getArgument("blockpos", WorldCoordinates.class)).getBlockPos((CommandSourceStack)context.getSource());
            int iterations = (Integer)context.getArgument("iterations", Integer.class);
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (!(blockEntity instanceof RandomizableContainer)) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Not a randomizable container!"));
                return 1;
            }
            RandomizableContainer rbe = (RandomizableContainer)blockEntity;
            float difficulty = (float)LootUtils.calculateDifficulty(((CommandSourceStack)context.getSource()).getLevel(), pos, rbe, iterations, true, (CommandSourceStack)context.getSource());
            MutableComponent component = Component.literal((String)"Difficulty: ").append((Component)Component.literal((String)(String.format("%.1f", Float.valueOf(difficulty * 100.0f)) + "%")).withColor(LootUtils.getColorForDifficulty(difficulty)));
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)component);
            return 1;
        }))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"lock").then(Commands.literal((String)"add").then(Commands.argument((String)"type", (ArgumentType)ResourceLocationArgument.id()).suggests((ctx, builder) -> SharedSuggestionProvider.suggest(MinigameTypeRegistry.REGISTRY.stream().map(ResourceLocation::toString), (SuggestionsBuilder)builder)).then(Commands.argument((String)"difficulty", (ArgumentType)FloatArgumentType.floatArg((float)0.0f)).then(Commands.argument((String)"seed", (ArgumentType)LongArgumentType.longArg()).then(((RequiredArgumentBuilder)Commands.argument((String)"perplayer", (ArgumentType)BoolArgumentType.bool()).then(Commands.argument((String)"blockpos", (ArgumentType)BlockPosArgument.blockPos()).executes(context -> {
            ResourceLocation type = (ResourceLocation)context.getArgument("type", ResourceLocation.class);
            if (!MinigameTypeRegistry.REGISTRY.contains(type)) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)("Non-existent minigame type: " + type.toString())));
                return 1;
            }
            Lock lock = new Lock(UUID.randomUUID(), new Box((Vec3i)((WorldCoordinates)context.getArgument("blockpos", WorldCoordinates.class)).getBlockPos((CommandSourceStack)context.getSource())), ((Float)context.getArgument("difficulty", Float.class)).floatValue(), (Long)context.getArgument("seed", Long.class), (Boolean)context.getArgument("perplayer", Boolean.class), new ArrayList<ResourceLocation>(), type);
            LockManager.addLock(((CommandSourceStack)context.getSource()).getLevel(), lock);
            return 1;
        }))).then(Commands.argument((String)"blockpos2", (ArgumentType)BlockPosArgument.blockPos()).executes(context -> {
            ResourceLocation type = (ResourceLocation)context.getArgument("type", ResourceLocation.class);
            if (!MinigameTypeRegistry.REGISTRY.contains(type)) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)("Non-existent minigame type: " + type.toString())));
                return 1;
            }
            Lock lock = new Lock(UUID.randomUUID(), new Box((Vec3i)((WorldCoordinates)context.getArgument("blockpos", WorldCoordinates.class)).getBlockPos((CommandSourceStack)context.getSource()), (Vec3i)((WorldCoordinates)context.getArgument("blockpos2", WorldCoordinates.class)).getBlockPos((CommandSourceStack)context.getSource())), ((Float)context.getArgument("difficulty", Float.class)).floatValue(), (Long)context.getArgument("seed", Long.class), (Boolean)context.getArgument("perplayer", Boolean.class), new ArrayList<ResourceLocation>(), type);
            LockManager.addLock(((CommandSourceStack)context.getSource()).getLevel(), lock);
            return 1;
        })))))))).then(Commands.literal((String)"remove").then(Commands.argument((String)"blockpos", (ArgumentType)BlockPosArgument.blockPos()).executes(context -> {
            BlockPos pos = ((WorldCoordinates)context.getArgument("blockpos", WorldCoordinates.class)).getBlockPos((CommandSourceStack)context.getSource());
            List<Lock> locks = LockManager.getLocksAt(((CommandSourceStack)context.getSource()).getLevel(), null, pos);
            if (locks.isEmpty()) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"No locks have been found at this position. Aborting..."));
                return 1;
            }
            LockManager.removeLock(((CommandSourceStack)context.getSource()).getLevel(), locks.getFirst());
            return 1;
        })))).then(Commands.literal((String)"get").then(Commands.argument((String)"blockpos", (ArgumentType)BlockPosArgument.blockPos()).executes(context -> {
            BlockPos pos = ((WorldCoordinates)context.getArgument("blockpos", WorldCoordinates.class)).getBlockPos((CommandSourceStack)context.getSource());
            List<Lock> locks = LockManager.getLocksAt(((CommandSourceStack)context.getSource()).getLevel(), null, pos);
            if (locks.isEmpty()) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"No locks have been found at this position. Aborting..."));
                return 1;
            }
            MutableComponent component = Component.literal((String)("Locks at " + pos.toShortString() + ":")).append("\n\n");
            for (Lock lock : locks) {
                component.append((Component)Component.literal((String)(lock.getUuid().toString() + ":")).withStyle(ChatFormatting.GOLD)).append("\n");
                component.append("    ").append((Component)Component.literal((String)"Type: ").withStyle(ChatFormatting.GRAY)).append(lock.getType((Level)((CommandSourceStack)context.getSource()).getLevel()).toString()).append("\n");
                component.append("    ").append((Component)Component.literal((String)"Difficulty: ").withStyle(ChatFormatting.GRAY)).append(String.format("%.2f", Float.valueOf(lock.getDifficulty()))).append("\n");
                component.append("    ").append((Component)Component.literal((String)"Seed: ").withStyle(ChatFormatting.GRAY)).append(String.valueOf(lock.getSeed())).append("\n");
                component.append("    ").append((Component)Component.literal((String)"Per-player: ").withStyle(ChatFormatting.GRAY)).append(String.valueOf(lock.isPerPlayer())).append("\n");
            }
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)component);
            return 1;
        })))).then(Commands.literal((String)"unlock").then(Commands.argument((String)"blockpos", (ArgumentType)BlockPosArgument.blockPos()).then(Commands.argument((String)"quality", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)10.0f)).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayer();
            if (player == null) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Should be run by a player. Aborting..."));
                return 1;
            }
            BlockPos pos = ((WorldCoordinates)context.getArgument("blockpos", WorldCoordinates.class)).getBlockPos((CommandSourceStack)context.getSource());
            List<Lock> locks = LockManager.getLocksAt(((CommandSourceStack)context.getSource()).getLevel(), player, pos);
            if (locks.isEmpty()) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"No locks have been found at this position. Aborting..."));
                return 1;
            }
            LootUtils.unlockWithQuality(((CommandSourceStack)context.getSource()).getLevel(), player, pos, locks.getFirst(), ((Float)context.getArgument("quality", Float.class)).floatValue());
            return 1;
        }))))));
    }
}

