/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.config.parser;

import codechicken.lib.config.AbstractConfigTag;
import codechicken.lib.config.ConfigCategoryImpl;
import codechicken.lib.config.ConfigTag;
import codechicken.lib.config.ConfigValueImpl;
import codechicken.lib.config.ConfigValueListImpl;
import codechicken.lib.config.ValueType;
import codechicken.lib.config.parser.ConfigSerializer;
import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TomlConfigSerializer
implements ConfigSerializer {
    @Override
    public void parse(Path file, ConfigCategoryImpl rootTag) throws IOException {
        try (CommentedFileConfig tomlConfig = (CommentedFileConfig)CommentedFileConfig.builder((Path)file).sync().preserveInsertionOrder().build();){
            tomlConfig.load();
            this.load("", rootTag, (Config)tomlConfig);
        }
    }

    private void load(String catName, ConfigCategoryImpl category, Config config) {
        for (Map.Entry entry : config.valueMap().entrySet()) {
            String path = TomlConfigSerializer.join(catName, (String)entry.getKey());
            Object value = entry.getValue();
            if (value instanceof Config) {
                Config conf = (Config)value;
                this.load(path, category.getCategory((String)entry.getKey()), conf);
                continue;
            }
            if (value instanceof List) {
                List lst = (List)value;
                category.getValueList((String)entry.getKey()).setValue(lst);
                continue;
            }
            category.getValue((String)entry.getKey()).setValue(value);
        }
    }

    @Override
    public void save(Path file, ConfigCategoryImpl rootTag) throws IOException {
        try (CommentedFileConfig tomlConfig = (CommentedFileConfig)CommentedFileConfig.builder((Path)file).preserveInsertionOrder().sync().writingMode(WritingMode.REPLACE).build();){
            for (ConfigTag child : rootTag.getChildren()) {
                this.write(tomlConfig, "", (AbstractConfigTag)child);
            }
            tomlConfig.save();
        }
    }

    private void write(CommentedFileConfig config, String catName, AbstractConfigTag<?> tag) {
        String path = TomlConfigSerializer.join(catName, tag.getName());
        if (!tag.getComment().isEmpty()) {
            config.setComment(path, String.join((CharSequence)"\n", tag.getComment()));
        }
        if (tag instanceof ConfigCategoryImpl) {
            ConfigCategoryImpl cat = (ConfigCategoryImpl)tag;
            for (ConfigTag child : cat.getChildren()) {
                if (child.isNetworkTag()) continue;
                this.write(config, path, (AbstractConfigTag)child);
            }
        } else if (tag instanceof ConfigValueImpl) {
            ConfigValueImpl val = (ConfigValueImpl)tag;
            config.set(path, TomlConfigSerializer.convert(val.getRawValue(), val.getType()));
        } else if (tag instanceof ConfigValueListImpl) {
            ConfigValueListImpl lst = (ConfigValueListImpl)tag;
            config.set(path, TomlConfigSerializer.convert(lst.getRawValue(), lst.getType()));
        }
    }

    private static List<?> convert(List<?> values, ValueType type) {
        if (type != ValueType.HEX) {
            return values;
        }
        ArrayList<Object> list = new ArrayList<Object>(values.size());
        for (Object value : values) {
            list.add(TomlConfigSerializer.convert(value, type));
        }
        return list;
    }

    private static Object convert(Object value, ValueType type) {
        if (type != ValueType.HEX) {
            return value;
        }
        return "0x" + Long.toString((long)((Integer)value).intValue() << 32 >>> 32, 16).toUpperCase();
    }

    private static String join(String a, String b) {
        if (a.isEmpty()) {
            return b;
        }
        return a + "." + b;
    }
}

