/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.internal;

import codechicken.lib.datagen.LanguageProvider;
import codechicken.lib.util.CCLTags;
import java.util.concurrent.CompletableFuture;
import net.covers1624.quack.util.CrashLock;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.data.BlockTagsProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

public class DataGenerators {
    private static final CrashLock LOCK = new CrashLock("Already Initialized");

    public static void init(IEventBus modBus) {
        LOCK.lock();
        modBus.addListener(DataGenerators::gatherDataGenerators);
    }

    private static void gatherDataGenerators(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        PackOutput output = gen.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        ExistingFileHelper files = event.getExistingFileHelper();
        BlockTags blockTagsProvider = new BlockTags(output, lookupProvider, files);
        gen.addProvider(event.includeServer(), (DataProvider)blockTagsProvider);
        gen.addProvider(event.includeServer(), (DataProvider)new ItemTags(output, lookupProvider, blockTagsProvider.contentsGetter(), files));
        gen.addProvider(event.includeClient() || event.includeServer(), (DataProvider)new LangUS(output, LanguageProvider.getDist(event)));
    }

    private static class BlockTags
    extends BlockTagsProvider {
        public BlockTags(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, ExistingFileHelper files) {
            super(output, lookupProvider, "codechickenlib", files);
        }

        protected void addTags(HolderLookup.Provider pProvider) {
            this.tag(CCLTags.Blocks.WOOLS).addTag(CCLTags.Blocks.WOOLS_WHITE).addTag(CCLTags.Blocks.WOOLS_ORANGE).addTag(CCLTags.Blocks.WOOLS_MAGENTA).addTag(CCLTags.Blocks.WOOLS_LIGHT_BLUE).addTag(CCLTags.Blocks.WOOLS_YELLOW).addTag(CCLTags.Blocks.WOOLS_LIME).addTag(CCLTags.Blocks.WOOLS_PINK).addTag(CCLTags.Blocks.WOOLS_GRAY).addTag(CCLTags.Blocks.WOOLS_LIGHT_GRAY).addTag(CCLTags.Blocks.WOOLS_CYAN).addTag(CCLTags.Blocks.WOOLS_PURPLE).addTag(CCLTags.Blocks.WOOLS_BLUE).addTag(CCLTags.Blocks.WOOLS_BROWN).addTag(CCLTags.Blocks.WOOLS_GREEN).addTag(CCLTags.Blocks.WOOLS_RED).addTag(CCLTags.Blocks.WOOLS_BLACK);
            this.tag(CCLTags.Blocks.WOOLS_WHITE).add((Object)Blocks.WHITE_WOOL);
            this.tag(CCLTags.Blocks.WOOLS_ORANGE).add((Object)Blocks.ORANGE_WOOL);
            this.tag(CCLTags.Blocks.WOOLS_MAGENTA).add((Object)Blocks.MAGENTA_WOOL);
            this.tag(CCLTags.Blocks.WOOLS_LIGHT_BLUE).add((Object)Blocks.LIGHT_BLUE_WOOL);
            this.tag(CCLTags.Blocks.WOOLS_YELLOW).add((Object)Blocks.YELLOW_WOOL);
            this.tag(CCLTags.Blocks.WOOLS_LIME).add((Object)Blocks.LIME_WOOL);
            this.tag(CCLTags.Blocks.WOOLS_PINK).add((Object)Blocks.PINK_WOOL);
            this.tag(CCLTags.Blocks.WOOLS_GRAY).add((Object)Blocks.GRAY_WOOL);
            this.tag(CCLTags.Blocks.WOOLS_LIGHT_GRAY).add((Object)Blocks.LIGHT_GRAY_WOOL);
            this.tag(CCLTags.Blocks.WOOLS_CYAN).add((Object)Blocks.CYAN_WOOL);
            this.tag(CCLTags.Blocks.WOOLS_PURPLE).add((Object)Blocks.PURPLE_WOOL);
            this.tag(CCLTags.Blocks.WOOLS_BLUE).add((Object)Blocks.BLUE_WOOL);
            this.tag(CCLTags.Blocks.WOOLS_BROWN).add((Object)Blocks.BROWN_WOOL);
            this.tag(CCLTags.Blocks.WOOLS_GREEN).add((Object)Blocks.GREEN_WOOL);
            this.tag(CCLTags.Blocks.WOOLS_RED).add((Object)Blocks.RED_WOOL);
            this.tag(CCLTags.Blocks.WOOLS_BLACK).add((Object)Blocks.BLACK_WOOL);
        }

        public String getName() {
            return "CodeChickenLib Block tags.";
        }
    }

    private static class ItemTags
    extends ItemTagsProvider {
        public ItemTags(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, CompletableFuture<TagsProvider.TagLookup<Block>> blockTagProvider, ExistingFileHelper files) {
            super(output, lookupProvider, blockTagProvider, "codechickenlib", files);
        }

        protected void addTags(HolderLookup.Provider pProvider) {
            this.tag(CCLTags.Items.WOOLS).addTag(CCLTags.Items.WOOLS_WHITE).addTag(CCLTags.Items.WOOLS_ORANGE).addTag(CCLTags.Items.WOOLS_MAGENTA).addTag(CCLTags.Items.WOOLS_LIGHT_BLUE).addTag(CCLTags.Items.WOOLS_YELLOW).addTag(CCLTags.Items.WOOLS_LIME).addTag(CCLTags.Items.WOOLS_PINK).addTag(CCLTags.Items.WOOLS_GRAY).addTag(CCLTags.Items.WOOLS_LIGHT_GRAY).addTag(CCLTags.Items.WOOLS_CYAN).addTag(CCLTags.Items.WOOLS_PURPLE).addTag(CCLTags.Items.WOOLS_BLUE).addTag(CCLTags.Items.WOOLS_BROWN).addTag(CCLTags.Items.WOOLS_GREEN).addTag(CCLTags.Items.WOOLS_RED).addTag(CCLTags.Items.WOOLS_BLACK);
            this.tag(CCLTags.Items.WOOLS_WHITE).add((Object)Items.WHITE_WOOL);
            this.tag(CCLTags.Items.WOOLS_ORANGE).add((Object)Items.ORANGE_WOOL);
            this.tag(CCLTags.Items.WOOLS_MAGENTA).add((Object)Items.MAGENTA_WOOL);
            this.tag(CCLTags.Items.WOOLS_LIGHT_BLUE).add((Object)Items.LIGHT_BLUE_WOOL);
            this.tag(CCLTags.Items.WOOLS_YELLOW).add((Object)Items.YELLOW_WOOL);
            this.tag(CCLTags.Items.WOOLS_LIME).add((Object)Items.LIME_WOOL);
            this.tag(CCLTags.Items.WOOLS_PINK).add((Object)Items.PINK_WOOL);
            this.tag(CCLTags.Items.WOOLS_GRAY).add((Object)Items.GRAY_WOOL);
            this.tag(CCLTags.Items.WOOLS_LIGHT_GRAY).add((Object)Items.LIGHT_GRAY_WOOL);
            this.tag(CCLTags.Items.WOOLS_CYAN).add((Object)Items.CYAN_WOOL);
            this.tag(CCLTags.Items.WOOLS_PURPLE).add((Object)Items.PURPLE_WOOL);
            this.tag(CCLTags.Items.WOOLS_BLUE).add((Object)Items.BLUE_WOOL);
            this.tag(CCLTags.Items.WOOLS_BROWN).add((Object)Items.BROWN_WOOL);
            this.tag(CCLTags.Items.WOOLS_GREEN).add((Object)Items.GREEN_WOOL);
            this.tag(CCLTags.Items.WOOLS_RED).add((Object)Items.RED_WOOL);
            this.tag(CCLTags.Items.WOOLS_BLACK).add((Object)Items.BLACK_WOOL);
        }

        public String getName() {
            return "CodeChickenLib Item tags.";
        }
    }

    public static class LangUS
    extends LanguageProvider {
        public LangUS(PackOutput output, LanguageProvider.Side side) {
            super(output, "codechickenlib", "en_us", side);
        }

        @Override
        protected void addTranslations() {
            this.addServer("ccl.commands.gc.before", "Before:");
            this.addServer("ccl.commands.gc.performing", "Performing GC..");
            this.addServer("ccl.commands.gc.after", "After:");
            this.addServer("ccl.commands.killall.fail", "Found no entities.");
            this.addServer("ccl.commands.killall.fail.player", "You cannot kill players with this command.");
            this.addServer("ccl.commands.killall.success", "Killed %s entities.");
            this.addServer("ccl.commands.killall.success.line", "Killed %s");
            this.addServer("ccl.commands.count.fail", "Found no entities.");
            this.addServer("ccl.commands.count.total", "Found %s entities.");
            this.addServer("ccl.energy_bar.energy_storage", "Energy Storage");
            this.addServer("ccl.energy_bar.capacity", "Capacity:");
            this.addServer("ccl.energy_bar.stored", "Stored:");
            this.addServer("ccl.energy_bar.rf", "RF");
            this.addServer("ccl.fluid_tank.fluid_storage", "Fluid Storage");
            this.addServer("ccl.fluid_tank.capacity", "Capacity:");
            this.addServer("ccl.fluid_tank.stored", "Stored:");
            this.addServer("ccl.fluid_tank.mb", "mB");
            this.addServer("ccl.fluid_tank.contains", "Contains:");
        }
    }
}

