/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render.shader;

import codechicken.lib.render.shader.ConstantCache;
import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;

public class ShaderConstantCache
implements ConstantCache {
    private final Int2IntArrayMap values = new Int2IntArrayMap();

    @Override
    public void constant1i(int id, int value) {
        if (id < 0) {
            throw new IllegalArgumentException("Constant location ID must be >= 0");
        }
        int oldValue = this.values.get(id);
        if (oldValue == value) {
            return;
        }
        this.values.put(id, value);
    }

    @Override
    public void constant1f(int id, float value) {
        if (id < 0) {
            throw new IllegalArgumentException("Constant location ID must be >= 0");
        }
        float oldValue = Float.intBitsToFloat(this.values.get(id));
        if (oldValue == value) {
            return;
        }
        this.values.put(id, Float.floatToIntBits(value));
    }

    @Override
    public void constant1b(int id, boolean value) {
        boolean oldValue;
        if (id < 0) {
            throw new IllegalArgumentException("Constant location ID must be >= 0");
        }
        boolean bl = oldValue = this.values.get(id) == 1;
        if (oldValue == value) {
            return;
        }
        this.values.put(id, value ? 1 : 0);
    }

    public int[] getIndices() {
        return this.values.keySet().toIntArray();
    }

    public int[] getValues() {
        return this.values.values().toIntArray();
    }
}

