/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.cognition.gui;

import com.cyanogen.cognition.config.Config;
import com.cyanogen.cognition.registries.RegisterItems;
import com.cyanogen.cognition.registries.RegisterMenus;
import com.cyanogen.cognition.utils.MiscUtils;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ExperienceObeliskMenu
extends AbstractContainerMenu {
    private ContainerData blockPositionData;
    public Level level;

    public ExperienceObeliskMenu(int id, Inventory inventory) {
        this(id, inventory, null);
        this.level = inventory.player.level();
        this.blockPositionData = new SimpleContainerData(3);
        this.addDataSlots(this.blockPositionData);
    }

    public ExperienceObeliskMenu(int id, Inventory inventory, @Nullable BlockPos pos) {
        super((MenuType)RegisterMenus.EXPERIENCE_OBELISK_MENU.get(), id);
        if (pos != null) {
            this.blockPositionData = new SimpleContainerData(3);
            this.blockPositionData.set(0, pos.getX());
            this.blockPositionData.set(1, pos.getY());
            this.blockPositionData.set(2, pos.getZ());
            this.addDataSlots(this.blockPositionData);
            this.sendAllDataToRemote();
        } else {
            this.blockPositionData = new SimpleContainerData(3);
        }
        this.level = inventory.player.level();
    }

    public BlockPos getBlockPos() {
        return new BlockPos(this.blockPositionData.get(0), this.blockPositionData.get(1), this.blockPositionData.get(2));
    }

    @Nullable
    public ItemStack quickMoveStack(Player player, int i) {
        return null;
    }

    public boolean stillValid(Player player) {
        double distance = 7.0;
        if (player.getItemInHand(InteractionHand.MAIN_HAND).is((Item)RegisterItems.MEMORY_TABLET.get())) {
            distance = (Double)Config.COMMON.bindingRange.get();
        }
        return MiscUtils.straightLineDistance(this.getBlockPos(), player.blockPosition()) <= distance;
    }
}

