/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.cognition.item;

import com.cyanogen.cognition.block.ExperienceObeliskBlock;
import com.cyanogen.cognition.block_entities.ExperienceObeliskEntity;
import com.cyanogen.cognition.config.Config;
import com.cyanogen.cognition.registries.RegisterSounds;
import com.cyanogen.cognition.saved_data.MemoryTabletData;
import com.cyanogen.cognition.utils.ExperienceUtils;
import com.cyanogen.cognition.utils.MiscUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingExperienceDropEvent;

public class MemoryTabletItem
extends Item {
    public MemoryTabletItem(Item.Properties properties) {
        super(properties);
    }

    public int getMaxStackSize(ItemStack stack) {
        return 1;
    }

    /*
     * Unable to fully structure code
     */
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        block3: {
            block4: {
                block5: {
                    if (level.isClientSide) break block3;
                    data = MemoryTabletData.getFromStorage(player);
                    if (data == null || !data.hasLinkedObelisk()) break block4;
                    pos = data.getLinkedObelisk();
                    state = level.getBlockState(pos);
                    if (player.isShiftKeyDown()) break block5;
                    var8_7 = state.getBlock();
                    if (!(var8_7 instanceof ExperienceObeliskBlock)) ** GOTO lbl-1000
                    obeliskBlock = (ExperienceObeliskBlock)var8_7;
                    if (data.dimensionMatches(level) && MiscUtils.straightLineDistance(player.blockPosition(), pos) <= (Double)Config.COMMON.bindingRange.get()) {
                        player.openMenu(obeliskBlock.getMenuProvider(state, level, pos));
                    } else lbl-1000:
                    // 2 sources

                    {
                        player.displayClientMessage((Component)Component.translatable((String)"message.cognition.memory_tablet.out_of_range"), true);
                    }
                    break block3;
                }
                player.displayClientMessage((Component)Component.translatable((String)"message.cognition.memory_tablet.query", (Object[])new Object[]{Component.literal((String)pos.toShortString()).withStyle(ChatFormatting.GREEN), Component.literal((String)data.getDimension()).withStyle(ChatFormatting.GRAY)}), true);
                break block3;
            }
            player.displayClientMessage((Component)Component.translatable((String)"message.cognition.memory_tablet.query_fail"), true);
        }
        if (player.isShiftKeyDown()) {
            return super.use(level, player, usedHand);
        }
        return InteractionResultHolder.sidedSuccess((Object)player.getItemInHand(usedHand), (boolean)level.isClientSide);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Player player = context.getPlayer();
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ExperienceObeliskEntity) {
            ExperienceObeliskEntity obelisk = (ExperienceObeliskEntity)blockEntity;
            if (player != null && player.isShiftKeyDown()) {
                obelisk.syncFromStorage();
                MemoryTabletData data = MemoryTabletData.getFromStorage(player);
                if (obelisk.getSavedPlayer().isEmpty()) {
                    obelisk.remember(player, data);
                    player.displayClientMessage((Component)Component.translatable((String)"message.cognition.memory_tablet.link", (Object[])new Object[]{Component.literal((String)pos.toShortString()).withStyle(ChatFormatting.GREEN)}), true);
                    level.playSound(null, player.blockPosition(), (SoundEvent)RegisterSounds.MEMORY_TABLET_LINK.get(), SoundSource.PLAYERS, 0.2f, 1.0f);
                } else if (obelisk.getSavedPlayer().equals(player.getStringUUID())) {
                    obelisk.forget(player, data);
                    player.displayClientMessage((Component)Component.translatable((String)"message.cognition.memory_tablet.unlink", (Object[])new Object[]{Component.literal((String)pos.toShortString()).withStyle(ChatFormatting.GREEN)}), true);
                    level.playSound(null, player.blockPosition(), (SoundEvent)RegisterSounds.MEMORY_TABLET_UNLINK.get(), SoundSource.PLAYERS, 0.2f, 0.8f);
                } else {
                    player.displayClientMessage((Component)Component.translatable((String)"message.cognition.memory_tablet.obelisk_in_use"), true);
                }
                return InteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
        }
        return super.useOn(context);
    }

    public static void handleDeath(LivingDeathEvent event) {
        boolean keepInventory = ((GameRules.BooleanValue)event.getEntity().level().getGameRules().getRule(GameRules.RULE_KEEPINVENTORY)).get();
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            MemoryTabletData data;
            Player player = (Player)livingEntity;
            if (!keepInventory && (data = MemoryTabletData.getFromStorage(player)) != null && data.hasLinkedObelisk()) {
                data.setExperienceToRecover(ExperienceUtils.getTotalXP(player));
            }
        }
    }

    public static void handleExperience(LivingExperienceDropEvent event) {
        Player player;
        MemoryTabletData data;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && (data = MemoryTabletData.getFromStorage(player = (Player)livingEntity)) != null && data.hasLinkedObelisk()) {
            event.setDroppedExperience(0);
            event.setCanceled(true);
        }
    }
}

