/*
 * Decompiled with CFR 0.152.
 */
package mrbysco.constructionstick.basics.option;

import java.util.ArrayList;
import java.util.List;
import mrbysco.constructionstick.api.IStickUpgrade;
import mrbysco.constructionstick.basics.StickUtil;
import mrbysco.constructionstick.basics.option.IOption;
import mrbysco.constructionstick.registry.ModDataComponents;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class StickUpgradesSelectable<T extends IStickUpgrade>
implements IOption<T> {
    private final ItemStack stack;
    private final String key;
    protected final List<T> upgrades;
    protected final List<T> specialUpgrades;
    private byte selector;

    public StickUpgradesSelectable(ItemStack stack, String key, T dVal) {
        T upgrade;
        this.key = key;
        this.upgrades = new ArrayList<T>();
        this.specialUpgrades = new ArrayList<T>();
        this.stack = stack;
        this.populateList(dVal);
        if (this.stack.has((DataComponentType)ModDataComponents.SELECTED.get()) && (upgrade = this.getUpgradeFromId((ResourceLocation)this.stack.get((DataComponentType)ModDataComponents.SELECTED.get()))) != null) {
            this.selector = (byte)this.upgrades.indexOf(upgrade);
        }
    }

    private T getUpgradeFromId(ResourceLocation id) {
        for (IStickUpgrade upgrade : this.upgrades) {
            if (!upgrade.getRegistryName().equals((Object)id)) continue;
            return (T)upgrade;
        }
        return null;
    }

    private void populateList(T dVal) {
        if (dVal != null) {
            this.upgrades.add(dVal);
        }
        for (IStickUpgrade upgrade : StickUtil.getAllUpgrades()) {
            if (!this.stack.has(upgrade.getStickComponent())) continue;
            if (upgrade.specialUpgrade()) {
                this.specialUpgrades.add(upgrade);
                continue;
            }
            this.upgrades.add(upgrade);
        }
    }

    @Override
    public DataComponentType<?> getComponentType() {
        return (DataComponentType)ModDataComponents.SELECTED.get();
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getValueString() {
        return this.get().getRegistryName().toString();
    }

    @Override
    public void setValueString(String val) {
        for (int i = 0; i < this.upgrades.size(); i = (int)((byte)(i + 1))) {
            if (!((IStickUpgrade)this.upgrades.get(i)).getRegistryName().toString().equals(val)) continue;
            this.selector = (byte)i;
            this.set((T)((IStickUpgrade)this.upgrades.get(i)));
            return;
        }
    }

    @Override
    public boolean isEnabled() {
        return this.upgrades.size() > 1;
    }

    @Override
    public void set(T val) {
        this.selector = (byte)this.upgrades.indexOf(val);
        this.fixSelector();
        this.stack.set((DataComponentType)ModDataComponents.SELECTED.get(), (Object)val.getRegistryName());
    }

    @Override
    public T get() {
        this.fixSelector();
        return (T)((IStickUpgrade)this.upgrades.get(this.selector));
    }

    @Override
    public T next(boolean dir) {
        this.selector = (byte)(this.selector + 1);
        this.fixSelector();
        return (T)this.get();
    }

    private void fixSelector() {
        if (this.selector < 0 || this.selector >= this.upgrades.size()) {
            this.selector = 0;
        }
    }

    public List<T> getUpgrades() {
        return this.upgrades;
    }

    public List<T> getSpecialUpgrades() {
        return this.specialUpgrades;
    }

    public boolean isCompatible(T upgrade) {
        ArrayList<T> allUpgrades = new ArrayList<T>(this.upgrades);
        allUpgrades.addAll(this.specialUpgrades);
        return allUpgrades.stream().noneMatch(up -> up.incompatibleWith((IStickUpgrade)upgrade));
    }
}

